/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import java.util.ArrayList;

public final class CoalesceOperandTypeInference
implements SqlOperandTypeInference {
    public static final CoalesceOperandTypeInference INSTANCE = new CoalesceOperandTypeInference();

    private CoalesceOperandTypeInference() {
    }

    @Override
    public void inferOperandTypes(SqlCallBinding binding, RelDataType returnType, RelDataType[] operandTypes) {
        if (operandTypes.length == 0) {
            return;
        }
        assert (binding.getOperandCount() == operandTypes.length);
        boolean hasParameters = HazelcastTypeUtils.hasParameters(binding);
        ArrayList<Integer> unknownOperandIndexes = new ArrayList<Integer>();
        RelDataType knownType = null;
        int knownTypePrecedence = Integer.MIN_VALUE;
        for (int i = 0; i < binding.getOperandCount(); ++i) {
            operandTypes[i] = binding.getOperandType(i);
            if (!operandTypes[i].equals(binding.getValidator().getUnknownType())) {
                int precedence;
                if (hasParameters && HazelcastTypeUtils.toHazelcastType(operandTypes[i].getSqlTypeName()).getTypeFamily().isNumericInteger()) {
                    operandTypes[i] = HazelcastTypeUtils.createType(binding.getTypeFactory(), SqlTypeName.BIGINT, operandTypes[i].isNullable());
                }
                if (knownTypePrecedence >= (precedence = HazelcastTypeUtils.precedenceOf(operandTypes[i]))) continue;
                knownType = operandTypes[i];
                knownTypePrecedence = precedence;
                continue;
            }
            unknownOperandIndexes.add(i);
        }
        if (knownType == null || knownType.getSqlTypeName() == SqlTypeName.NULL && hasParameters) {
            throw new HazelcastCallBinding(binding).newValidationSignatureError();
        }
        for (Integer index : unknownOperandIndexes) {
            operandTypes[index.intValue()] = knownType;
        }
    }
}

