/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;

public final class ComparisonOperatorOperandTypeInference
implements SqlOperandTypeInference {
    public static final ComparisonOperatorOperandTypeInference INSTANCE = new ComparisonOperatorOperandTypeInference();

    private ComparisonOperatorOperandTypeInference() {
    }

    @Override
    public void inferOperandTypes(SqlCallBinding binding, RelDataType returnType, RelDataType[] operandTypes) {
        assert (operandTypes.length == 2);
        assert (binding.getOperandCount() == 2);
        boolean hasParameters = HazelcastTypeUtils.hasParameters(binding);
        int knownTypeOperandIndex = -1;
        RelDataType knownType = null;
        for (int i = 0; i < binding.getOperandCount(); ++i) {
            operandTypes[i] = binding.getOperandType(i);
            if (operandTypes[i].equals(binding.getValidator().getUnknownType()) || knownType != null && knownType.getSqlTypeName() != SqlTypeName.NULL) continue;
            knownType = operandTypes[i];
            knownTypeOperandIndex = i;
        }
        if (knownType == null || knownType.getSqlTypeName() == SqlTypeName.NULL && hasParameters) {
            throw new HazelcastCallBinding(binding).newValidationSignatureError();
        }
        operandTypes[1 - knownTypeOperandIndex] = SqlTypeName.INTERVAL_TYPES.contains((Object)knownType.getSqlTypeName()) && operandTypes[1 - knownTypeOperandIndex].getSqlTypeName() == SqlTypeName.NULL ? HazelcastTypeUtils.createType(binding.getTypeFactory(), SqlTypeName.TIMESTAMP, true) : knownType;
    }
}

