/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators.misc;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operand.OperandCheckerProgram;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;

public final class HazelcastArithmeticOperatorUtils {
    private HazelcastArithmeticOperatorUtils() {
    }

    public static boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure, SqlKind kind) {
        RelDataType firstType = binding.getOperandType(0);
        RelDataType secondType = binding.getOperandType(1);
        if (HazelcastTypeUtils.isTemporalType(firstType) || HazelcastTypeUtils.isTemporalType(secondType)) {
            return HazelcastArithmeticOperatorUtils.checkTemporalOperands(binding, throwOnFailure, kind, firstType, secondType);
        }
        if (!HazelcastTypeUtils.isNumericType(firstType) || !HazelcastTypeUtils.isNumericType(secondType)) {
            return HazelcastArithmeticOperatorUtils.fail(binding, throwOnFailure);
        }
        RelDataType type = HazelcastTypeUtils.withHigherPrecedence(firstType, secondType);
        switch (kind) {
            case PLUS: 
            case MINUS: 
            case DIVIDE: {
                if (!HazelcastTypeUtils.isNumericIntegerType(type)) break;
                int bitWidth = ((HazelcastIntegerType)type).getBitWidth() + 1;
                type = HazelcastIntegerType.create(bitWidth, type.isNullable());
                break;
            }
            case TIMES: {
                if (!HazelcastTypeUtils.isNumericIntegerType(type)) break;
                assert (firstType instanceof HazelcastIntegerType);
                assert (secondType instanceof HazelcastIntegerType);
                int firstBitWidth = ((HazelcastIntegerType)firstType).getBitWidth();
                int secondBitWidth = ((HazelcastIntegerType)secondType).getBitWidth();
                type = HazelcastIntegerType.create(firstBitWidth + secondBitWidth, type.isNullable());
                break;
            }
            default: {
                assert (kind == SqlKind.MOD);
                if (!HazelcastTypeUtils.isNumericInexactType(type)) break;
                return HazelcastArithmeticOperatorUtils.fail(binding, throwOnFailure);
            }
        }
        TypedOperandChecker checker = TypedOperandChecker.forType(type);
        return new OperandCheckerProgram(checker, checker).check(binding, throwOnFailure);
    }

    private static boolean checkTemporalOperands(HazelcastCallBinding binding, boolean throwOnFailure, SqlKind kind, RelDataType firstType, RelDataType secondType) {
        if (HazelcastTypeUtils.isTemporalType(firstType)) {
            if (HazelcastTypeUtils.isIntervalType(secondType) && (kind == SqlKind.PLUS || kind == SqlKind.MINUS)) {
                return new OperandCheckerProgram(TypedOperandChecker.forType(HazelcastArithmeticOperatorUtils.convertToTimestampIfNeeded(binding, firstType)), TypedOperandChecker.forType(secondType)).check(binding, throwOnFailure);
            }
        } else {
            assert (HazelcastTypeUtils.isTemporalType(secondType));
            if (HazelcastTypeUtils.isIntervalType(firstType) && kind == SqlKind.PLUS) {
                return new OperandCheckerProgram(TypedOperandChecker.forType(firstType), TypedOperandChecker.forType(HazelcastArithmeticOperatorUtils.convertToTimestampIfNeeded(binding, secondType))).check(binding, throwOnFailure);
            }
        }
        return HazelcastArithmeticOperatorUtils.fail(binding, throwOnFailure);
    }

    private static RelDataType convertToTimestampIfNeeded(HazelcastCallBinding binding, RelDataType type) {
        assert (HazelcastTypeUtils.isTemporalType(type));
        if (type.getSqlTypeName() == SqlTypeName.DATE) {
            return HazelcastTypeUtils.createType(binding.getTypeFactory(), SqlTypeName.TIMESTAMP, type.isNullable());
        }
        return type;
    }

    private static boolean fail(HazelcastCallBinding binding, boolean throwOnFailure) {
        if (throwOnFailure) {
            throw binding.newValidationSignatureError();
        }
        return false;
    }
}

