/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators.predicate;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlDynamicParam;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlValidator;
import com.hazelcast.sql.impl.calcite.validate.param.NumericPrecedenceParameterConverter;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import com.hazelcast.sql.impl.type.QueryDataType;

public final class HazelcastComparisonPredicateUtils {
    private HazelcastComparisonPredicateUtils() {
    }

    public static boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        SqlNode first = binding.operand(0);
        SqlNode second = binding.operand(1);
        HazelcastSqlValidator validator = binding.getValidator();
        RelDataType firstType = validator.deriveType(binding.getScope(), first);
        RelDataType secondType = validator.deriveType(binding.getScope(), second);
        assert (!firstType.equals(validator.getUnknownType()));
        assert (!secondType.equals(validator.getUnknownType()));
        return HazelcastComparisonPredicateUtils.checkOperandTypes(binding, throwOnFailure, validator, first, firstType, second, secondType);
    }

    private static boolean checkOperandTypes(HazelcastCallBinding callBinding, boolean throwOnFailure, HazelcastSqlValidator validator, SqlNode first, RelDataType firstType, SqlNode second, RelDataType secondType) {
        RelDataType winningType = HazelcastTypeUtils.withHigherPrecedence(firstType, secondType);
        if (winningType == firstType) {
            return HazelcastComparisonPredicateUtils.checkOperandTypesWithPrecedence(callBinding, throwOnFailure, validator, first, firstType, second, secondType, 1);
        }
        assert (winningType == secondType);
        return HazelcastComparisonPredicateUtils.checkOperandTypesWithPrecedence(callBinding, throwOnFailure, validator, second, secondType, first, firstType, 0);
    }

    private static boolean checkOperandTypesWithPrecedence(HazelcastCallBinding callBinding, boolean throwOnFailure, HazelcastSqlValidator validator, SqlNode high, RelDataType highType, SqlNode low, RelDataType lowType, int lowIndex) {
        boolean valid;
        QueryDataType highHZType = HazelcastTypeUtils.toHazelcastType(highType.getSqlTypeName());
        QueryDataType lowHZType = HazelcastTypeUtils.toHazelcastType(lowType.getSqlTypeName());
        if (highHZType.getTypeFamily().isNumeric()) {
            HazelcastComparisonPredicateUtils.setNumericParameterConverter(validator, high, highHZType);
            HazelcastComparisonPredicateUtils.setNumericParameterConverter(validator, low, highHZType);
        }
        if ((valid = validator.getTypeCoercion().rowTypeElementCoercion(callBinding.getScope(), low, highType, lowOperandNode -> callBinding.getCall().setOperand(lowIndex, (SqlNode)lowOperandNode))) && highHZType == QueryDataType.OBJECT && lowHZType != QueryDataType.OBJECT) {
            valid = false;
        }
        if (!valid && throwOnFailure) {
            throw callBinding.newValidationSignatureError();
        }
        return valid;
    }

    private static void setNumericParameterConverter(HazelcastSqlValidator validator, SqlNode node, QueryDataType type) {
        if (node.getKind() == SqlKind.DYNAMIC_PARAM) {
            SqlDynamicParam node0 = (SqlDynamicParam)node;
            NumericPrecedenceParameterConverter converter = new NumericPrecedenceParameterConverter(node0.getIndex(), node.getParserPosition(), type);
            validator.setParameterConverter(node0.getIndex(), converter);
        }
    }
}

