/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators.predicate;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.runtime.CalciteResource;
import com.hazelcast.org.apache.calcite.runtime.Resources;
import com.hazelcast.org.apache.calcite.sql.ExplicitOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.fun.SqlInOperator;
import com.hazelcast.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.org.apache.calcite.sql.type.ComparableOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorException;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorImpl;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.Static;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operators.common.HazelcastOperandTypeCheckerAware;
import java.util.ArrayList;
import java.util.List;

public class HazelcastInOperator
extends SqlInOperator
implements HazelcastOperandTypeCheckerAware {
    public static final HazelcastInOperator IN = new HazelcastInOperator("IN", false);
    public static final HazelcastInOperator NOT_IN = new HazelcastInOperator("NOT IN", true);
    protected static final HazelcastInOperatorResource HZRESOURCE = Resources.create(HazelcastInOperatorResource.class);

    public HazelcastInOperator(String name, boolean negated) {
        super(name, negated ? SqlKind.NOT_IN : SqlKind.IN);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        RelDataType rightRowType;
        RelDataType leftRowType;
        ComparableOperandTypeChecker checker;
        boolean coerced;
        RelDataType rightType;
        SqlNodeList nodeList;
        List<SqlNode> operands = call.getOperandList();
        assert (operands.size() == 2);
        SqlNode left = operands.get(0);
        SqlNode right = operands.get(1);
        RelDataTypeFactory typeFactory = validator.getTypeFactory();
        RelDataType leftType = validator.deriveType(scope, left);
        if (right instanceof SqlNodeList) {
            ArrayList<RelDataType> rightTypeList = new ArrayList<RelDataType>();
            nodeList = (SqlNodeList)right;
            for (int i = 0; i < nodeList.size(); ++i) {
                SqlNode node = nodeList.get(i);
                RelDataType nodeType = validator.deriveType(scope, node);
                rightTypeList.add(nodeType);
            }
            rightType = typeFactory.leastRestrictive(rightTypeList);
            if (null == rightType && validator.config().typeCoercionEnabled()) {
                rightType = validator.getTypeCoercion().getWiderTypeFor(rightTypeList, false);
            }
            if (null == rightType) {
                throw validator.newValidationError(right, Static.RESOURCE.incompatibleTypesInList());
            }
        } else {
            throw validator.newValidationError(call, HZRESOURCE.noSubQueryAllowed());
        }
        ((SqlValidatorImpl)validator).setValidatedNodeType(nodeList, rightType);
        HazelcastCallBinding hazelcastCallBinding = this.prepareBinding(new SqlCallBinding(validator, scope, call));
        if (hazelcastCallBinding.isTypeCoercionEnabled() && (coerced = hazelcastCallBinding.getValidator().getTypeCoercion().inOperationCoercion(hazelcastCallBinding))) {
            leftType = validator.deriveType(scope, (SqlNode)call.operand(0));
            rightType = validator.deriveType(scope, (SqlNode)call.operand(1));
        }
        if (!(checker = (ComparableOperandTypeChecker)OperandTypes.COMPARABLE_UNORDERED_COMPARABLE_UNORDERED).checkOperandTypes(new ExplicitOperatorBinding(hazelcastCallBinding, ImmutableList.of(leftRowType = SqlTypeUtil.promoteToRowType(typeFactory, leftType, null), rightRowType = SqlTypeUtil.promoteToRowType(typeFactory, rightType, null))), hazelcastCallBinding)) {
            throw validator.newValidationError(call, Static.RESOURCE.incompatibleValueType(SqlStdOperatorTable.IN.getName()));
        }
        return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BOOLEAN), HazelcastInOperator.anyNullable(leftRowType.getFieldList()) || HazelcastInOperator.anyNullable(rightRowType.getFieldList()));
    }

    private static boolean anyNullable(List<RelDataTypeField> fieldList) {
        for (RelDataTypeField field : fieldList) {
            if (!field.getType().isNullable()) continue;
            return true;
        }
        return false;
    }

    static interface HazelcastInOperatorResource
    extends CalciteResource {
        @Resources.BaseMessage(value="Sub-queries are not allowed for IN operator.")
        public Resources.ExInst<SqlValidatorException> noSubQueryAllowed();
    }
}

