/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators.string;

import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operand.OperandCheckerProgram;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.calcite.validate.operators.common.HazelcastFunction;

public class HazelcastPositionFunction
extends HazelcastFunction {
    public static final HazelcastPositionFunction INSTANCE = new HazelcastPositionFunction();

    public HazelcastPositionFunction() {
        super("POSITION", SqlKind.POSITION, ReturnTypes.INTEGER_NULLABLE, new ReplaceUnknownOperandTypeInference(new SqlTypeName[]{SqlTypeName.VARCHAR, SqlTypeName.VARCHAR, SqlTypeName.INTEGER}), SqlFunctionCategory.NUMERIC);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(2, 3);
    }

    @Override
    protected boolean checkOperandTypes(HazelcastCallBinding callBinding, boolean throwOnFailure) {
        switch (callBinding.getOperandCount()) {
            case 2: {
                return new OperandCheckerProgram(TypedOperandChecker.VARCHAR, TypedOperandChecker.VARCHAR).check(callBinding, throwOnFailure);
            }
            case 3: {
                return new OperandCheckerProgram(TypedOperandChecker.VARCHAR, TypedOperandChecker.VARCHAR, TypedOperandChecker.INTEGER).check(callBinding, throwOnFailure);
            }
        }
        return false;
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.sep("IN");
        ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        if (call.operandCount() == 3) {
            writer.sep("FROM");
            ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
        }
        writer.endFunCall(frame);
    }
}

