/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.types;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.util.ConversionUtil;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeSystem;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nullable;

public final class HazelcastTypeFactory
extends SqlTypeFactoryImpl {
    public static final HazelcastTypeFactory INSTANCE = new HazelcastTypeFactory();
    private static final RelDataType TYPE_TIME = new HazelcastType(SqlTypeName.TIME, false, 6);
    private static final RelDataType TYPE_TIME_NULLABLE = new HazelcastType(SqlTypeName.TIME, true, 6);
    private static final RelDataType TYPE_TIMESTAMP = new HazelcastType(SqlTypeName.TIMESTAMP, false, 6);
    private static final RelDataType TYPE_TIMESTAMP_NULLABLE = new HazelcastType(SqlTypeName.TIMESTAMP, true, 6);
    private static final RelDataType TYPE_TIMESTAMP_WITH_TIME_ZONE = new HazelcastType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, false, 6);
    private static final RelDataType TYPE_TIMESTAMP_WITH_TIME_ZONE_NULLABLE = new HazelcastType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, true, 6);
    private static final RelDataType TYPE_OBJECT = new HazelcastType(SqlTypeName.ANY, false);
    private static final RelDataType TYPE_OBJECT_NULLABLE = new HazelcastType(SqlTypeName.ANY, true);

    private HazelcastTypeFactory() {
        super(HazelcastTypeSystem.INSTANCE);
    }

    public RelDataType createSqlType(SqlTypeName typeName, boolean nullable) {
        RelDataType type = this.createSqlType(typeName);
        assert (!type.isNullable());
        if (nullable) {
            type = this.createTypeWithNullability(type, true);
        }
        return type;
    }

    @Override
    public Charset getDefaultCharset() {
        return Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME);
    }

    @Override
    public RelDataType createSqlType(SqlTypeName typeName) {
        RelDataType type = this.createType(typeName);
        if (type == null) {
            type = super.createSqlType(typeName);
        }
        return type;
    }

    @Override
    public RelDataType createSqlType(SqlTypeName typeName, int precision) {
        RelDataType type = this.createType(typeName);
        if (type == null) {
            type = super.createSqlType(typeName, precision);
        }
        return type;
    }

    @Override
    public RelDataType createSqlType(SqlTypeName typeName, int precision, int scale) {
        RelDataType type = this.createType(typeName);
        if (type == null) {
            type = super.createSqlType(typeName, precision, scale);
        }
        return type;
    }

    @Nullable
    private RelDataType createType(SqlTypeName typeName) {
        if (typeName == SqlTypeName.DECIMAL) {
            return super.createSqlType(SqlTypeName.DECIMAL, 38, 38);
        }
        if (typeName == SqlTypeName.ANY) {
            return TYPE_OBJECT;
        }
        if (typeName == SqlTypeName.TIME) {
            return TYPE_TIME;
        }
        if (typeName == SqlTypeName.TIMESTAMP) {
            return TYPE_TIMESTAMP;
        }
        if (typeName == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
            return TYPE_TIMESTAMP_WITH_TIME_ZONE;
        }
        if (HazelcastTypeUtils.isNumericIntegerType(typeName)) {
            return HazelcastIntegerType.create(typeName, false);
        }
        return null;
    }

    @Override
    public RelDataType createTypeWithNullability(RelDataType type, boolean nullable) {
        if (HazelcastTypeUtils.isNumericIntegerType(type.getSqlTypeName())) {
            return HazelcastIntegerType.create((HazelcastIntegerType)type, nullable);
        }
        if (type.getSqlTypeName() == SqlTypeName.ANY) {
            return nullable ? TYPE_OBJECT_NULLABLE : TYPE_OBJECT;
        }
        if (type.getSqlTypeName() == SqlTypeName.TIME) {
            return nullable ? TYPE_TIME_NULLABLE : TYPE_TIME;
        }
        if (type.getSqlTypeName() == SqlTypeName.TIMESTAMP) {
            return nullable ? TYPE_TIMESTAMP_NULLABLE : TYPE_TIMESTAMP;
        }
        if (type.getSqlTypeName() == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
            return nullable ? TYPE_TIMESTAMP_WITH_TIME_ZONE_NULLABLE : TYPE_TIMESTAMP_WITH_TIME_ZONE;
        }
        return super.createTypeWithNullability(type, nullable);
    }

    @Override
    public RelDataType leastRestrictive(List<RelDataType> types) {
        RelDataType selected = super.leastRestrictive(types);
        if (selected == null) {
            return null;
        }
        SqlTypeName selectedTypeName = selected.getSqlTypeName();
        if (HazelcastTypeUtils.isNumericIntegerType(selectedTypeName)) {
            return HazelcastTypeFactory.leastRestrictive(selected, types);
        }
        if (selectedTypeName == SqlTypeName.DOUBLE) {
            boolean seenDouble = false;
            boolean seenReal = false;
            for (RelDataType type : types) {
                if (type.getSqlTypeName() == SqlTypeName.DOUBLE) {
                    seenDouble = true;
                    break;
                }
                if (type.getSqlTypeName() != SqlTypeName.REAL) continue;
                seenReal = true;
            }
            if (!seenDouble && seenReal) {
                selected = this.createSqlType(SqlTypeName.REAL, selected.isNullable());
            }
        }
        return selected;
    }

    private static RelDataType leastRestrictive(RelDataType targetType, List<RelDataType> types) {
        SqlTypeName typeName = targetType.getSqlTypeName();
        assert (HazelcastTypeUtils.isNumericIntegerType(typeName));
        int maxBitWidth = -1;
        RelDataType maxBitWidthType = null;
        for (RelDataType type : types) {
            int bitWidth;
            if (type.getSqlTypeName() != typeName || (bitWidth = ((HazelcastIntegerType)type).getBitWidth()) <= maxBitWidth) continue;
            maxBitWidth = bitWidth;
            maxBitWidthType = type;
        }
        assert (maxBitWidthType != null);
        assert (maxBitWidthType.getSqlTypeName() == typeName);
        return HazelcastIntegerType.create((HazelcastIntegerType)maxBitWidthType, targetType.isNullable());
    }

    @Override
    public RelDataType createJoinType(RelDataType ... types) {
        return this.createUnknownType();
    }
}

