/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.scan.index;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.query.impl.GlobalIndexPartitionTracker;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.exec.scan.KeyValueIterator;
import com.hazelcast.sql.impl.exec.scan.MapScanExec;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.exec.scan.index.MapIndexScanExecIterator;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.List;

public class MapIndexScanExec
extends MapScanExec {
    private final String indexName;
    private final IndexFilter indexFilter;
    private final List<QueryDataType> converterTypes;
    private final int componentCount;
    private InternalIndex index;
    private long partitionStampValue;
    private List<Boolean> ascs;

    public MapIndexScanExec(int id, MapContainer map, PartitionIdSet parts, QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, List<QueryPath> fieldPaths, List<QueryDataType> fieldTypes, List<Integer> projects, Expression<Boolean> filter, InternalSerializationService serializationService, String indexName, int componentCount, IndexFilter indexFilter, List<QueryDataType> converterTypes, List<Boolean> ascs) {
        super(id, map, parts, keyDescriptor, valueDescriptor, fieldPaths, fieldTypes, projects, filter, serializationService);
        this.indexName = indexName;
        this.componentCount = componentCount;
        this.indexFilter = indexFilter;
        this.converterTypes = converterTypes;
        this.ascs = ascs;
    }

    @Override
    protected KeyValueIterator createIterator() {
        Indexes indexes = this.map.getIndexes();
        if (indexes == null) {
            throw QueryException.error(1009, "Cannot use the index \"" + this.indexName + "\" of the IMap \"" + this.map.getName() + "\" because it is not global (make sure the property \"" + ClusterProperty.GLOBAL_HD_INDEX_ENABLED + "\" is set to \"true\")").markInvalidate();
        }
        this.index = indexes.getIndex(this.indexName);
        if (this.index == null) {
            throw QueryException.error(1009, "Cannot use the index \"" + this.indexName + "\" of the IMap \"" + this.map.getName() + "\" because it doesn't exist").markInvalidate();
        }
        GlobalIndexPartitionTracker.PartitionStamp partitionStamp = this.index.getPartitionStamp();
        if (partitionStamp == null || !partitionStamp.partitions.equals(this.partitions)) {
            throw this.invalidIndexStamp();
        }
        this.partitionStampValue = partitionStamp.stamp;
        return new MapIndexScanExecIterator(this.mapName, this.index, this.componentCount, this.indexFilter, this.ascs, this.converterTypes, this.ctx);
    }

    @Override
    protected void validateConsistency() {
        if (!this.index.validatePartitionStamp(this.partitionStampValue)) {
            throw this.invalidIndexStamp();
        }
    }

    private QueryException invalidIndexStamp() {
        throw QueryException.error(1009, "Cannot use the index \"" + this.indexName + "\" of the IMap \"" + this.mapName + "\" due to concurrent migration, or because index creation is still in progress").markInvalidate();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{mapName=" + this.mapName + ", fieldPaths=" + this.fieldPaths + ", projects=" + this.projects + "indexName=" + this.indexName + ", indexFilter=" + this.indexFilter + ", remainderFilter=" + this.filter + ", partitionCount=" + this.partitions.size() + ", ascs=" + this.ascs + '}';
    }
}

