/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.math;

import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.BiExpressionWithType;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.math.ExpressionMath;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.SqlDaySecondInterval;
import com.hazelcast.sql.impl.type.SqlYearMonthInterval;
import java.math.BigDecimal;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;

public final class MinusFunction<T>
extends BiExpressionWithType<T>
implements IdentifiedDataSerializable {
    public MinusFunction() {
    }

    private MinusFunction(Expression<?> operand1, Expression<?> operand2, QueryDataType resultType) {
        super(operand1, operand2, resultType);
    }

    public static Expression<?> create(Expression<?> operand1, Expression<?> operand2, QueryDataType resultType) {
        if (ExpressionMath.canSimplifyTemporalPlusMinus(operand1, operand2)) {
            return operand1;
        }
        return new MinusFunction(operand1, operand2, resultType);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 28;
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context) {
        Object left = this.operand1.eval(row, context);
        if (left == null) {
            return null;
        }
        Object right = this.operand2.eval(row, context);
        if (right == null) {
            return null;
        }
        QueryDataTypeFamily family = this.resultType.getTypeFamily();
        if (family.isTemporal()) {
            return (T)MinusFunction.evalTemporal(left, right, family);
        }
        return (T)MinusFunction.evalNumeric((Number)left, (Number)right, family);
    }

    private static Object evalNumeric(Number left, Number right, QueryDataTypeFamily family) {
        switch (family) {
            case TINYINT: {
                return (byte)(left.byteValue() - right.byteValue());
            }
            case SMALLINT: {
                return (short)(left.shortValue() - right.shortValue());
            }
            case INTEGER: {
                return left.intValue() - right.intValue();
            }
            case BIGINT: {
                try {
                    return Math.subtractExact(left.longValue(), right.longValue());
                }
                catch (ArithmeticException e) {
                    throw QueryException.error(2000, "BIGINT overflow in '-' operator (consider adding explicit CAST to DECIMAL)");
                }
            }
            case REAL: {
                return Float.valueOf(left.floatValue() - right.floatValue());
            }
            case DOUBLE: {
                return left.doubleValue() - right.doubleValue();
            }
            case DECIMAL: {
                return ((BigDecimal)left).subtract((BigDecimal)right, ExpressionMath.DECIMAL_MATH_CONTEXT);
            }
        }
        throw new IllegalArgumentException("unexpected result family: " + (Object)((Object)family));
    }

    private static Object evalTemporal(Object left, Object right, QueryDataTypeFamily family) {
        switch (family) {
            case TIME: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_TIME_ZONE: {
                Temporal temporal = (Temporal)left;
                if (right instanceof SqlDaySecondInterval) {
                    return temporal.minus(((SqlDaySecondInterval)right).getMillis(), ChronoUnit.MILLIS);
                }
                assert (family != QueryDataTypeFamily.TIME);
                assert (right instanceof SqlYearMonthInterval);
                return temporal.minus(((SqlYearMonthInterval)right).getMonths(), ChronoUnit.MONTHS);
            }
        }
        throw new IllegalArgumentException("Unexpected result family: " + (Object)((Object)family));
    }
}

