/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.string;

import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.TriExpression;
import com.hazelcast.sql.impl.expression.math.MathFunctionUtils;
import com.hazelcast.sql.impl.expression.string.StringFunctionUtils;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;

public class PositionFunction
extends TriExpression<Integer>
implements IdentifiedDataSerializable {
    static final int SQL_START_INDEX = 1;
    static final int SQL_NOT_FOUND = 0;

    public PositionFunction() {
    }

    private PositionFunction(Expression<?> text, Expression<?> search, Expression<?> start) {
        super(text, search, start);
    }

    public static PositionFunction create(Expression<?> search, Expression<?> text, Expression<?> start) {
        return new PositionFunction(text, search, start);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 70;
    }

    @Override
    public Integer eval(Row row, ExpressionEvalContext context) {
        String text = StringFunctionUtils.asVarchar(this.operand1, row, context);
        if (text == null) {
            return null;
        }
        String search = StringFunctionUtils.asVarchar(this.operand2, row, context);
        if (search == null) {
            return null;
        }
        if (this.operand3 == null) {
            return 1 + StringFunctionUtils.search(text, search, 0);
        }
        Integer start = MathFunctionUtils.asInt(this.operand3, row, context);
        if (start == null) {
            return null;
        }
        if (1 <= start && start <= text.length()) {
            return 1 + StringFunctionUtils.search(text, search, start - 1);
        }
        return 0;
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.INT;
    }
}

