/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MappingField
implements IdentifiedDataSerializable {
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String EXTERNAL_NAME = "externalName";
    private Map<String, Object> properties;

    public MappingField() {
    }

    public MappingField(String name, QueryDataType type) {
        this(name, type, null);
    }

    public MappingField(String name, QueryDataType type, String externalName) {
        this.properties = new HashMap<String, Object>();
        this.properties.put(NAME, Objects.requireNonNull(name));
        this.properties.put(TYPE, Objects.requireNonNull(type));
        if (externalName != null) {
            this.properties.put(EXTERNAL_NAME, externalName);
        }
    }

    public String name() {
        return Objects.requireNonNull((String)this.properties.get(NAME), "missing name property");
    }

    public QueryDataType type() {
        return Objects.requireNonNull((QueryDataType)this.properties.get(TYPE), "missing type property");
    }

    public String externalName() {
        return (String)this.properties.get(EXTERNAL_NAME);
    }

    public void setExternalName(String extName) {
        this.properties.put(EXTERNAL_NAME, extName);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 76;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.properties);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.properties = (Map)in.readObject();
    }

    public String toString() {
        return "MappingField{properties=" + this.properties + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingField that = (MappingField)o;
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }
}

