/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema.map.sample;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecord;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.sql.impl.FieldsUtil;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.JetMapMetadataResolver;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.schema.map.sample.MapSampleMetadata;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nonnull;

public final class MapSampleMetadataResolver {
    private MapSampleMetadataResolver() {
    }

    public static MapSampleMetadata resolve(InternalSerializationService ss, JetMapMetadataResolver jetMapMetadataResolver, Object target, boolean key) {
        try {
            if (target instanceof Portable) {
                target = ss.toData(target);
            }
            if (target instanceof Data) {
                Data data = (Data)target;
                if (data.isPortable()) {
                    return MapSampleMetadataResolver.resolvePortable(ss.getPortableContext().lookupClassDefinition(data), key, jetMapMetadataResolver);
                }
                if (data.isJson()) {
                    throw new UnsupportedOperationException("JSON objects are not supported.");
                }
                return MapSampleMetadataResolver.resolveClass(ss.toObject(data).getClass(), key, jetMapMetadataResolver);
            }
            if (target instanceof PortableGenericRecord) {
                return MapSampleMetadataResolver.resolvePortable(((PortableGenericRecord)target).getClassDefinition(), key, jetMapMetadataResolver);
            }
            return MapSampleMetadataResolver.resolveClass(target.getClass(), key, jetMapMetadataResolver);
        }
        catch (Exception e) {
            throw QueryException.error("Failed to resolve " + (key ? "key" : "value") + " metadata: " + e.getMessage(), e);
        }
    }

    private static MapSampleMetadata resolvePortable(@Nonnull ClassDefinition classDef, boolean isKey, JetMapMetadataResolver jetMapMetadataResolver) {
        LinkedHashMap<String, MapTableField> fields = new LinkedHashMap<String, MapTableField>();
        SortedMap<String, QueryDataType> simpleFields = FieldsUtil.resolvePortable(classDef);
        for (Map.Entry fieldEntry : simpleFields.entrySet()) {
            String name = (String)fieldEntry.getKey();
            TableField oldValue = fields.put(name, new MapTableField(name, (QueryDataType)fieldEntry.getValue(), false, new QueryPath(name, isKey)));
            assert (oldValue == null);
        }
        String topName = isKey ? QueryPath.KEY : QueryPath.VALUE;
        QueryPath topPath = isKey ? QueryPath.KEY_PATH : QueryPath.VALUE_PATH;
        fields.remove(topName);
        fields.put(topName, new MapTableField(topName, QueryDataType.OBJECT, !fields.isEmpty(), topPath));
        return new MapSampleMetadata(GenericQueryTargetDescriptor.DEFAULT, jetMapMetadataResolver.resolvePortable(classDef, isKey), new LinkedHashMap<String, TableField>(fields));
    }

    private static MapSampleMetadata resolveClass(Class<?> clazz, boolean isKey, JetMapMetadataResolver jetMapMetadataResolver) {
        LinkedHashMap<String, TableField> fields = new LinkedHashMap<String, TableField>();
        QueryDataType topType = QueryDataTypeUtils.resolveTypeForClass(clazz);
        if (topType == QueryDataType.OBJECT) {
            SortedMap<String, Class<?>> simpleFields = FieldsUtil.resolveClass(clazz);
            for (Map.Entry fieldEntry : simpleFields.entrySet()) {
                String fieldName = (String)fieldEntry.getKey();
                QueryDataType type = QueryDataTypeUtils.resolveTypeForClass((Class)fieldEntry.getValue());
                TableField oldValue = fields.put(fieldName, new MapTableField(fieldName, type, false, new QueryPath(fieldName, isKey)));
                assert (oldValue == null);
            }
        }
        String topName = isKey ? QueryPath.KEY : QueryPath.VALUE;
        QueryPath topPath = isKey ? QueryPath.KEY_PATH : QueryPath.VALUE_PATH;
        fields.remove(topName);
        fields.put(topName, new MapTableField(topName, topType, !fields.isEmpty(), topPath));
        return new MapSampleMetadata(GenericQueryTargetDescriptor.DEFAULT, jetMapMetadataResolver.resolveClass(clazz, isKey), fields);
    }
}

