/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws.impl;

import com.hazelcast.aws.security.EC2RequestSigner;
import com.hazelcast.aws.utility.CloudyUtility;
import com.hazelcast.aws.utility.Environment;
import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.nio.IOUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DescribeInstances {
    public static final String IAM_ROLE_ENDPOINT = "169.254.169.254";
    public static final String IAM_TASK_ROLE_ENDPOINT = "169.254.170.2";
    private EC2RequestSigner rs;
    private AwsConfig awsConfig;
    private String endpoint;
    private Map<String, String> attributes = new HashMap<String, String>();

    public DescribeInstances(AwsConfig awsConfig, String endpoint) throws IOException {
        if (awsConfig == null) {
            throw new IllegalArgumentException("AwsConfig is required!");
        }
        this.awsConfig = awsConfig;
        this.endpoint = endpoint;
        this.checkKeysFromIamRoles(new Environment());
        String timeStamp = this.getFormattedTimestamp();
        this.rs = new EC2RequestSigner(awsConfig, timeStamp, endpoint);
        this.attributes.put("Action", this.getClass().getSimpleName());
        this.attributes.put("Version", "2014-06-15");
        this.attributes.put("X-Amz-Algorithm", "AWS4-HMAC-SHA256");
        this.attributes.put("X-Amz-Credential", this.rs.createFormattedCredential());
        this.attributes.put("X-Amz-Date", timeStamp);
        this.attributes.put("X-Amz-SignedHeaders", "host");
        this.attributes.put("X-Amz-Expires", "30");
    }

    DescribeInstances(AwsConfig awsConfig) {
        if (awsConfig == null) {
            throw new IllegalArgumentException("AwsConfig is required!");
        }
        this.awsConfig = awsConfig;
    }

    void checkKeysFromIamRoles(Environment env) throws IOException {
        if (this.awsConfig.getAccessKey() != null && this.awsConfig.getIamRole() == null) {
            return;
        }
        this.tryGetDefaultIamRole();
        if (this.awsConfig.getIamRole() == null || "".equals(this.awsConfig.getIamRole())) {
            this.getKeysFromIamTaskRole(env);
        } else {
            this.getKeysFromIamRole();
        }
    }

    private void getKeysFromIamTaskRole(Environment env) throws IOException {
        String uri = env.getEnvVar("AWS_CONTAINER_CREDENTIALS_RELATIVE_URI");
        if (uri == null) {
            throw new IllegalArgumentException("Could not acquire credentials! Did not find declared AWS access key or IAM Role, and could not discover IAM Task Role or default role.");
        }
        uri = "http://169.254.170.2" + uri;
        String json = "";
        try {
            json = this.retrieveRoleFromURI(uri);
            this.parseAndStoreRoleCreds(json);
        }
        catch (Exception io) {
            throw new InvalidConfigurationException("Unable to retrieve credentials from IAM Task Role. URI: " + uri + ". \n HTTP Response content: " + json, (Throwable)io);
        }
    }

    String retrieveRoleFromURI(String uri) throws IOException {
        StringBuilder response = new StringBuilder();
        InputStreamReader is = null;
        BufferedReader reader = null;
        try {
            String resp;
            URL url = new URL(uri);
            is = new InputStreamReader(url.openStream(), "UTF-8");
            reader = new BufferedReader(is);
            while ((resp = reader.readLine()) != null) {
                response = response.append(resp);
            }
            String string = response.toString();
            return string;
        }
        catch (IOException io) {
            throw new InvalidConfigurationException("Unable to lookup role in URI: " + uri, (Throwable)io);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void tryGetDefaultIamRole() throws IOException {
        if (this.awsConfig.getIamRole() != null && !"".equals(this.awsConfig.getIamRole()) && !"DEFAULT".equals(this.awsConfig.getIamRole())) {
            return;
        }
        try {
            String query = "latest/meta-data/iam/security-credentials/";
            String uri = "http://169.254.169.254/" + query;
            String roleName = this.retrieveRoleFromURI(uri);
            this.awsConfig.setIamRole(roleName);
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Invalid Aws Configuration", (Throwable)e);
        }
    }

    private void getKeysFromIamRole() {
        try {
            String query = "latest/meta-data/iam/security-credentials/" + this.awsConfig.getIamRole();
            String uri = "http://169.254.169.254/" + query;
            String json = this.retrieveRoleFromURI(uri);
            this.parseAndStoreRoleCreds(json);
        }
        catch (Exception io) {
            throw new InvalidConfigurationException("Unable to retrieve credentials from IAM Role: " + this.awsConfig.getIamRole(), (Throwable)io);
        }
    }

    private void parseAndStoreRoleCreds(String json) {
        JsonObject roleAsJson = JsonObject.readFrom((String)json);
        this.awsConfig.setAccessKey(roleAsJson.getString("AccessKeyId", null));
        this.awsConfig.setSecretKey(roleAsJson.getString("SecretAccessKey", null));
        this.attributes.put("X-Amz-Security-Token", roleAsJson.getString("Token", null));
    }

    @Deprecated
    public Map<String, String> parseIamRole(BufferedReader reader) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        Pattern keyPattern = Pattern.compile("\"(.*?)\" : ");
        Pattern valuePattern = Pattern.compile(" : \"(.*?)\",");
        String line = reader.readLine();
        while (line != null) {
            if (line.contains(":")) {
                Matcher keyMatcher = keyPattern.matcher(line);
                Matcher valueMatcher = valuePattern.matcher(line);
                if (keyMatcher.find() && valueMatcher.find()) {
                    String key = keyMatcher.group(1);
                    String value = valueMatcher.group(1);
                    map.put(key, value);
                }
            }
            line = reader.readLine();
        }
        return map;
    }

    private String getFormattedTimestamp() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> execute() throws Exception {
        Map<String, String> map;
        String signature = this.rs.sign("ec2", this.attributes);
        InputStream stream = null;
        this.attributes.put("X-Amz-Signature", signature);
        try {
            Map<String, String> response;
            stream = this.callService(this.endpoint);
            map = response = CloudyUtility.unmarshalTheResponse(stream, this.awsConfig);
        }
        catch (Throwable throwable) {
            IOUtil.closeResource(stream);
            throw throwable;
        }
        IOUtil.closeResource((Closeable)stream);
        return map;
    }

    private InputStream callService(String endpoint) throws Exception {
        String query = this.rs.getCanonicalizedQueryString(this.attributes);
        URL url = new URL("https", endpoint, -1, "/?" + query);
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        httpConnection.setRequestMethod("GET");
        httpConnection.setDoOutput(false);
        httpConnection.connect();
        return httpConnection.getInputStream();
    }
}

