/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.AWSClient;
import com.hazelcast.aws.AwsProperties;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AwsDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final ILogger LOGGER = Logger.getLogger(AwsDiscoveryStrategy.class);
    private final AWSClient aws;
    private final int port;
    private final Map<String, Object> memberMetadata = new HashMap<String, Object>();

    public AwsDiscoveryStrategy(Map<String, Comparable> properties) {
        super(LOGGER, properties);
        this.port = (Integer)this.getOrDefault(AwsProperties.PORT.getDefinition(), Integer.valueOf(5701));
        try {
            this.aws = new AWSClient(this.getAwsConfig());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationException("AWS configuration is not valid", (Throwable)e);
        }
    }

    AwsDiscoveryStrategy(Map<String, Comparable> properties, AWSClient client) {
        super(LOGGER, properties);
        this.port = (Integer)this.getOrDefault(AwsProperties.PORT.getDefinition(), Integer.valueOf(5701));
        this.aws = client;
    }

    private AwsConfig getAwsConfig() throws IllegalArgumentException {
        String hostHeader;
        AwsConfig config = new AwsConfig().setEnabled(true).setSecurityGroupName(this.getOrNull(AwsProperties.SECURITY_GROUP_NAME)).setTagKey(this.getOrNull(AwsProperties.TAG_KEY)).setTagValue(this.getOrNull(AwsProperties.TAG_VALUE)).setIamRole(this.getOrNull(AwsProperties.IAM_ROLE));
        String property = this.getOrNull(AwsProperties.ACCESS_KEY);
        if (property != null) {
            config.setAccessKey(property);
        }
        if ((property = this.getOrNull(AwsProperties.SECRET_KEY)) != null) {
            config.setSecretKey(property);
        }
        Integer timeout = (Integer)this.getOrDefault(AwsProperties.CONNECTION_TIMEOUT_SECONDS.getDefinition(), Integer.valueOf(10));
        config.setConnectionTimeoutSeconds(timeout.intValue());
        String region = this.getOrNull(AwsProperties.REGION);
        if (region != null) {
            config.setRegion(region);
        }
        if ((hostHeader = this.getOrNull(AwsProperties.HOST_HEADER)) != null) {
            config.setHostHeader(hostHeader);
        }
        this.reviewConfiguration(config);
        return config;
    }

    public Map<String, Object> discoverLocalMetadata() {
        if (this.memberMetadata.isEmpty()) {
            this.memberMetadata.put("hazelcast.partition.group.zone", this.aws.getAvailabilityZone());
        }
        return this.memberMetadata;
    }

    private void reviewConfiguration(AwsConfig config) {
        if (StringUtil.isNullOrEmptyAfterTrim((String)config.getSecretKey()) || StringUtil.isNullOrEmptyAfterTrim((String)config.getAccessKey())) {
            if (!StringUtil.isNullOrEmptyAfterTrim((String)config.getIamRole())) {
                this.getLogger().info("Describe instances will be queried with iam-role, please make sure given iam-role have ec2:DescribeInstances policy attached.");
            } else {
                this.getLogger().warning("Describe instances will be queried with iam-role assigned to EC2 instance, please make sure given iam-role have ec2:DescribeInstances policy attached.");
            }
        } else if (!StringUtil.isNullOrEmptyAfterTrim((String)config.getIamRole())) {
            this.getLogger().info("No need to define iam-role, when access and secret keys are configured!");
        }
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        try {
            Map<String, String> privatePublicIpAddressPairs = this.aws.getAddresses();
            if (privatePublicIpAddressPairs.isEmpty()) {
                this.getLogger().warning("No EC2 instances found!");
                return Collections.emptyList();
            }
            if (this.getLogger().isFinestEnabled()) {
                StringBuilder sb = new StringBuilder("Found the following EC2 instances:\n");
                for (Map.Entry<String, String> entry : privatePublicIpAddressPairs.entrySet()) {
                    sb.append("    ").append(entry.getKey()).append(" : ").append(entry.getValue()).append("\n");
                }
                this.getLogger().finest(sb.toString());
            }
            ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>(privatePublicIpAddressPairs.size());
            for (Map.Entry<String, String> entry : privatePublicIpAddressPairs.entrySet()) {
                nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(entry.getKey(), this.port), new Address(entry.getValue(), this.port)));
            }
            return nodes;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private String getOrNull(AwsProperties awsProperties) {
        return (String)((Object)this.getOrNull(awsProperties.getDefinition()));
    }
}

