/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws.utility;

import com.hazelcast.aws.utility.RetryUtils;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public final class MetadataUtil {
    public static final String INSTANCE_METADATA_URI = "http://169.254.169.254/latest/meta-data/";
    public static final String IAM_SECURITY_CREDENTIALS_URI = "iam/security-credentials/";
    public static final String AVAILABILITY_ZONE_URI = "placement/availability-zone/";
    private static final ILogger LOGGER = Logger.getLogger(MetadataUtil.class);

    private MetadataUtil() {
    }

    public static String retrieveMetadataFromURI(String uri, int timeoutInSeconds) {
        StringBuilder response = new StringBuilder();
        InputStreamReader is = null;
        BufferedReader reader = null;
        try {
            String resp;
            URLConnection url = new URL(uri).openConnection();
            url.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(timeoutInSeconds));
            is = new InputStreamReader(url.getInputStream(), "UTF-8");
            reader = new BufferedReader(is);
            while ((resp = reader.readLine()) != null) {
                response = response.append(resp);
            }
            String string = response.toString();
            return string;
        }
        catch (IOException io) {
            throw new InvalidConfigurationException("Unable to lookup role in URI: " + uri, (Throwable)io);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.warning((Throwable)e);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.warning((Throwable)e);
                }
            }
        }
    }

    public static String retrieveMetadataFromURI(final String uri, final int timeoutInSeconds, int retries) {
        return RetryUtils.retry(new Callable<String>(){

            @Override
            public String call() {
                return MetadataUtil.retrieveMetadataFromURI(uri, timeoutInSeconds);
            }
        }, retries);
    }

    public static String getAvailabilityZone(int connectionTimeoutSeconds, int connectionRetries) {
        String uri = INSTANCE_METADATA_URI.concat(AVAILABILITY_ZONE_URI);
        return MetadataUtil.retrieveMetadataFromURI(uri, connectionTimeoutSeconds, connectionRetries);
    }
}

