/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.AwsClient;
import com.hazelcast.aws.AwsClientConfigurator;
import com.hazelcast.aws.AwsConfig;
import com.hazelcast.aws.AwsProperties;
import com.hazelcast.aws.PortRange;
import com.hazelcast.cluster.Address;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AwsDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final ILogger LOGGER = Logger.getLogger(AwsDiscoveryStrategy.class);
    private static final String DEFAULT_PORT_RANGE = "5701-5708";
    private static final Integer DEFAULT_CONNECTION_RETRIES = 3;
    private static final int DEFAULT_CONNECTION_TIMEOUT_SECONDS = 10;
    private static final int DEFAULT_READ_TIMEOUT_SECONDS = 10;
    private final AwsClient awsClient;
    private final PortRange portRange;
    private final Map<String, String> memberMetadata = new HashMap<String, String>();

    AwsDiscoveryStrategy(Map<String, Comparable> properties) {
        super(LOGGER, properties);
        AwsConfig awsConfig = this.createAwsConfig();
        LOGGER.info("Using AWS discovery plugin with configuration: " + awsConfig);
        this.awsClient = AwsClientConfigurator.createAwsClient(awsConfig);
        this.portRange = awsConfig.getHzPort();
    }

    AwsDiscoveryStrategy(Map<String, Comparable> properties, AwsClient client) {
        super(LOGGER, properties);
        this.awsClient = client;
        this.portRange = this.createAwsConfig().getHzPort();
    }

    private AwsConfig createAwsConfig() {
        try {
            return AwsConfig.builder().setAccessKey(this.getOrNull(AwsProperties.ACCESS_KEY)).setSecretKey(this.getOrNull(AwsProperties.SECRET_KEY)).setRegion((String)((Object)this.getOrDefault(AwsProperties.REGION.getDefinition(), null))).setIamRole(this.getOrNull(AwsProperties.IAM_ROLE)).setHostHeader((String)((Object)this.getOrNull(AwsProperties.HOST_HEADER.getDefinition()))).setSecurityGroupName(this.getOrNull(AwsProperties.SECURITY_GROUP_NAME)).setTagKey(this.getOrNull(AwsProperties.TAG_KEY)).setTagValue(this.getOrNull(AwsProperties.TAG_VALUE)).setConnectionTimeoutSeconds((Integer)this.getOrDefault(AwsProperties.CONNECTION_TIMEOUT_SECONDS.getDefinition(), Integer.valueOf(10))).setConnectionRetries((Integer)this.getOrDefault(AwsProperties.CONNECTION_RETRIES.getDefinition(), DEFAULT_CONNECTION_RETRIES)).setReadTimeoutSeconds((Integer)this.getOrDefault(AwsProperties.READ_TIMEOUT_SECONDS.getDefinition(), Integer.valueOf(10))).setHzPort(new PortRange(this.getPortRange())).setCluster(this.getOrNull(AwsProperties.CLUSTER)).setFamily(this.getOrNull(AwsProperties.FAMILY)).setServiceName(this.getOrNull(AwsProperties.SERVICE_NAME)).build();
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationException("AWS configuration is not valid", (Throwable)e);
        }
    }

    private String getPortRange() {
        Comparable portRange = this.getOrNull(AwsProperties.PORT.getDefinition());
        if (portRange == null) {
            return DEFAULT_PORT_RANGE;
        }
        return portRange.toString();
    }

    public Map<String, String> discoverLocalMetadata() {
        if (this.memberMetadata.isEmpty()) {
            String availabilityZone = this.awsClient.getAvailabilityZone();
            LOGGER.info(String.format("Availability zone found: '%s'", availabilityZone));
            this.memberMetadata.put("hazelcast.partition.group.zone", availabilityZone);
        }
        return this.memberMetadata;
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        try {
            Map<String, String> addresses = this.awsClient.getAddresses();
            AwsDiscoveryStrategy.logResult(addresses);
            ArrayList<DiscoveryNode> result = new ArrayList<DiscoveryNode>();
            for (Map.Entry<String, String> entry : addresses.entrySet()) {
                for (int port = this.portRange.getFromPort(); port <= this.portRange.getToPort(); ++port) {
                    Address privateAddress = new Address(entry.getKey(), port);
                    Address publicAddress = new Address(entry.getValue(), port);
                    result.add((DiscoveryNode)new SimpleDiscoveryNode(privateAddress, publicAddress));
                }
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.warning("Cannot discover nodes, returning empty list", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static void logResult(Map<String, String> addresses) {
        if (addresses.isEmpty()) {
            LOGGER.warning("No IP addresses found!");
        }
        LOGGER.fine(String.format("Found the following (private => public) addresses: %s", addresses));
    }

    private String getOrNull(AwsProperties awsProperties) {
        return (String)((Object)this.getOrNull(awsProperties.getDefinition()));
    }
}

