/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.AwsConfig;
import com.hazelcast.aws.AwsCredentials;
import com.hazelcast.aws.AwsRequestSigner;
import com.hazelcast.aws.AwsRequestUtils;
import com.hazelcast.aws.StringUtils;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

class AwsEcsApi {
    private final String endpoint;
    private final AwsConfig awsConfig;
    private final AwsRequestSigner requestSigner;
    private final Clock clock;

    AwsEcsApi(String endpoint, AwsConfig awsConfig, AwsRequestSigner requestSigner, Clock clock) {
        this.endpoint = endpoint;
        this.awsConfig = awsConfig;
        this.requestSigner = requestSigner;
        this.clock = clock;
    }

    List<String> listTasks(String cluster, AwsCredentials credentials) {
        String body = this.createBodyListTasks(cluster);
        Map<String, String> headers = this.createHeadersListTasks(body, credentials);
        String response = this.callAwsService(body, headers);
        return this.parseListTasks(response);
    }

    private String createBodyListTasks(String cluster) {
        JsonObject body = new JsonObject();
        body.add("cluster", cluster);
        if (StringUtils.isNotEmpty(this.awsConfig.getFamily())) {
            body.add("family", this.awsConfig.getFamily());
        }
        if (StringUtils.isNotEmpty(this.awsConfig.getServiceName())) {
            body.add("serviceName", this.awsConfig.getServiceName());
        }
        return body.toString();
    }

    private Map<String, String> createHeadersListTasks(String body, AwsCredentials credentials) {
        return this.createHeaders(body, credentials, "ListTasks");
    }

    private List<String> parseListTasks(String response) {
        return AwsEcsApi.toStream(AwsEcsApi.toJson(response).get("taskArns")).map(JsonValue::asString).collect(Collectors.toList());
    }

    List<Task> describeTasks(String clusterArn, List<String> taskArns, AwsCredentials credentials) {
        String body = this.createBodyDescribeTasks(clusterArn, taskArns);
        Map<String, String> headers = this.createHeadersDescribeTasks(body, credentials);
        String response = this.callAwsService(body, headers);
        return this.parseDescribeTasks(response);
    }

    private String createBodyDescribeTasks(String cluster, List<String> taskArns) {
        JsonArray jsonArray = new JsonArray();
        taskArns.stream().map(Json::value).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        return new JsonObject().add("tasks", (JsonValue)jsonArray).add("cluster", cluster).toString();
    }

    private Map<String, String> createHeadersDescribeTasks(String body, AwsCredentials credentials) {
        return this.createHeaders(body, credentials, "DescribeTasks");
    }

    private List<Task> parseDescribeTasks(String response) {
        return AwsEcsApi.toStream(AwsEcsApi.toJson(response).get("tasks")).flatMap(e -> this.toTask((JsonValue)e).map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
    }

    private Optional<Task> toTask(JsonValue taskJson) {
        String availabilityZone = taskJson.asObject().get("availabilityZone").asString();
        return AwsEcsApi.toStream(taskJson.asObject().get("containers")).flatMap(e -> AwsEcsApi.toStream(e.asObject().get("networkInterfaces"))).map(e -> e.asObject().get("privateIpv4Address").asString()).map(e -> new Task((String)e, availabilityZone)).findFirst();
    }

    private Map<String, String> createHeaders(String body, AwsCredentials credentials, String awsTargetAction) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotEmpty(credentials.getToken())) {
            headers.put("X-Amz-Security-Token", credentials.getToken());
        }
        headers.put("Host", this.endpoint);
        headers.put("X-Amz-Target", String.format("AmazonEC2ContainerServiceV20141113.%s", awsTargetAction));
        headers.put("Content-Type", "application/x-amz-json-1.1");
        headers.put("Accept-Encoding", "identity");
        String timestamp = AwsRequestUtils.currentTimestamp(this.clock);
        headers.put("X-Amz-Date", timestamp);
        headers.put("Authorization", this.requestSigner.authHeader(Collections.emptyMap(), headers, body, credentials, timestamp, "POST"));
        return headers;
    }

    private String callAwsService(String body, Map<String, String> headers) {
        return AwsRequestUtils.createRestClient(AwsRequestUtils.urlFor(this.endpoint), this.awsConfig).withHeaders(headers).withBody(body).post();
    }

    private static JsonObject toJson(String jsonString) {
        return Json.parse((String)jsonString).asObject();
    }

    private static Stream<JsonValue> toStream(JsonValue json) {
        return StreamSupport.stream(json.asArray().spliterator(), false);
    }

    static class Task {
        private final String privateAddress;
        private final String availabilityZone;

        Task(String privateAddress, String availabilityZone) {
            this.privateAddress = privateAddress;
            this.availabilityZone = availabilityZone;
        }

        String getPrivateAddress() {
            return this.privateAddress;
        }

        String getAvailabilityZone() {
            return this.availabilityZone;
        }
    }
}

