/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.internal.config.DomConfigHelper;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

final class XmlNode {
    private Node node;

    private XmlNode(Node node) {
        this.node = node;
    }

    static XmlNode create(String xmlString) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document doc = dbf.newDocumentBuilder().parse(new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8)));
            return new XmlNode(doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    Node getNode() {
        return this.node;
    }

    List<XmlNode> getSubNodes(String name) {
        return StreamSupport.stream(DomConfigHelper.childElements((Node)this.node).spliterator(), false).filter(e -> name.equals(DomConfigHelper.cleanNodeName((Node)e))).map(XmlNode::new).collect(Collectors.toList());
    }

    String getValue(String name) {
        return this.getSubNodes(name).stream().map(XmlNode::getNode).map(Node::getFirstChild).map(Node::getNodeValue).findFirst().orElse(null);
    }
}

