/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.azure;

import com.hazelcast.azure.AzureDiscoveryStrategy;
import com.hazelcast.azure.AzureProperties;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.management.configuration.ManagementConfiguration;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.naming.ServiceUnavailableException;

public final class AzureAuthHelper {
    private static final ILogger LOGGER = Logger.getLogger(AzureDiscoveryStrategy.class);

    private AzureAuthHelper() {
    }

    public static Configuration getAzureConfiguration(Map<String, Comparable> properties) throws Exception {
        Configuration config = AzureAuthHelper.createConfiguration((String)AzureProperties.getOrNull(AzureProperties.SUBSCRIPTION_ID, properties), (String)AzureProperties.getOrNull(AzureProperties.CLIENT_ID, properties), (String)AzureProperties.getOrNull(AzureProperties.TENANT_ID, properties), (String)AzureProperties.getOrNull(AzureProperties.CLIENT_SECRET, properties));
        return config;
    }

    private static Configuration createConfiguration(String subscriptionId, String clientId, String tenantId, String clientSecret) throws URISyntaxException, IOException, ServiceUnavailableException, ExecutionException, InterruptedException {
        String baseUri = "https://management.core.windows.net";
        return ManagementConfiguration.configure(null, (URI)new URI(baseUri), (String)subscriptionId, (String)AzureAuthHelper.getAccessTokenFromServicePrincipalCredentials(clientId, tenantId, clientSecret).getAccessToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AuthenticationResult getAccessTokenFromServicePrincipalCredentials(String clientId, String tenantId, String clientSecret) throws ServiceUnavailableException, MalformedURLException, ExecutionException, InterruptedException {
        AuthenticationResult result = null;
        ExecutorService service = null;
        try {
            service = Executors.newFixedThreadPool(1);
            AuthenticationContext context = new AuthenticationContext("https://login.windows.net/" + tenantId, false, service);
            ClientCredential cred = new ClientCredential(clientId, clientSecret);
            Future future = context.acquireToken("https://management.azure.com/", cred, null);
            result = (AuthenticationResult)future.get();
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
        if (result == null) {
            throw new ServiceUnavailableException("authentication result was null");
        }
        return result;
    }
}

