/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.azure;

import com.hazelcast.azure.AzureAuthHelper;
import com.hazelcast.azure.AzureProperties;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.microsoft.azure.management.compute.ComputeManagementClient;
import com.microsoft.azure.management.compute.ComputeManagementService;
import com.microsoft.azure.management.compute.VirtualMachineOperations;
import com.microsoft.azure.management.compute.models.InstanceViewStatus;
import com.microsoft.azure.management.compute.models.NetworkInterfaceReference;
import com.microsoft.azure.management.compute.models.NetworkProfile;
import com.microsoft.azure.management.compute.models.VirtualMachine;
import com.microsoft.azure.management.compute.models.VirtualMachineInstanceView;
import com.microsoft.azure.management.compute.models.VirtualMachineListResponse;
import com.microsoft.azure.management.network.NetworkInterfaceOperations;
import com.microsoft.azure.management.network.NetworkResourceProviderClient;
import com.microsoft.azure.management.network.NetworkResourceProviderService;
import com.microsoft.azure.management.network.PublicIpAddressOperations;
import com.microsoft.azure.management.network.models.NetworkInterface;
import com.microsoft.azure.management.network.models.NetworkInterfaceIpConfiguration;
import com.microsoft.azure.management.network.models.PublicIpAddress;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.exception.ServiceException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class AzureDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final ILogger LOGGER = Logger.getLogger(AzureDiscoveryStrategy.class);
    private ComputeManagementClient computeManagement;
    private NetworkResourceProviderClient networkManagement;
    private Map<String, Comparable> properties;
    private final Map<String, Object> memberMetaData = new HashMap<String, Object>();

    public AzureDiscoveryStrategy(Map<String, Comparable> properties) {
        super(LOGGER, properties);
        this.properties = properties;
    }

    public void start() {
        try {
            Configuration config = AzureAuthHelper.getAzureConfiguration(this.properties);
            this.computeManagement = ComputeManagementService.create((Configuration)config);
            this.networkManagement = NetworkResourceProviderService.create((Configuration)config);
        }
        catch (Exception e) {
            LOGGER.finest("Failed to start Azure SPI", (Throwable)e);
        }
    }

    public Map<String, Object> discoverLocalMetadata() {
        if (this.memberMetaData.size() == 0) {
            this.discoverNodes();
        }
        return this.memberMetaData;
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        try {
            VirtualMachineOperations vmOps = this.computeManagement.getVirtualMachinesOperations();
            String resourceGroup = (String)AzureProperties.getOrNull(AzureProperties.GROUP_NAME, this.properties);
            String clusterId = (String)AzureProperties.getOrNull(AzureProperties.CLUSTER_ID, this.properties);
            VirtualMachineListResponse vms = vmOps.list(resourceGroup);
            ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>();
            for (VirtualMachine vm : vms.getVirtualMachines()) {
                DiscoveryNode node;
                NetworkProfile netProfile = vm.getNetworkProfile();
                HashMap tags = vm.getTags();
                if (tags.get(clusterId) == null || !this.isVirtualMachineOn(vmOps, vm)) continue;
                int port = Integer.parseInt((String)tags.get(clusterId));
                String faultDomainId = this.getFaultDomain(vmOps, vm, resourceGroup);
                if (faultDomainId != null) {
                    this.memberMetaData.put("hazelcast.partition.group.zone", faultDomainId);
                }
                if ((node = this.buildDiscoveredNode(faultDomainId, netProfile, port)) == null) continue;
                nodes.add(node);
            }
            LOGGER.info("Azure Discovery SPI Discovered " + nodes.size() + " nodes");
            return nodes;
        }
        catch (Exception e) {
            LOGGER.finest("Failed to discover nodes with Azure SPI", (Throwable)e);
            return null;
        }
    }

    private String getFaultDomain(VirtualMachineOperations vmOps, VirtualMachine vm, String resourceGroup) {
        try {
            return vmOps.getWithInstanceView(resourceGroup, vm.getName()).getVirtualMachine().getInstanceView().getPlatformFaultDomain().toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void destroy() {
    }

    private boolean isVirtualMachineOn(VirtualMachineOperations vmOps, VirtualMachine vm) throws IOException, ServiceException, URISyntaxException {
        String rgName = (String)AzureProperties.getOrNull(AzureProperties.GROUP_NAME, this.properties);
        VirtualMachine vmWithInstanceView = vmOps.getWithInstanceView(rgName, vm.getName()).getVirtualMachine();
        VirtualMachineInstanceView vmInstanceView = vmWithInstanceView.getInstanceView();
        for (InstanceViewStatus status : vmInstanceView.getStatuses()) {
            if (!status.getCode().equals("PowerState/running")) continue;
            return true;
        }
        return false;
    }

    private String getResourceNameFromUri(String referenceUri) {
        String[] parts = referenceUri.split("/");
        String name = parts[parts.length - 1];
        return name;
    }

    private DiscoveryNode buildDiscoveredNode(String faultDomainId, NetworkProfile profile, int port) throws Exception {
        PublicIpAddressOperations pubOps = this.networkManagement.getPublicIpAddressesOperations();
        String rgName = (String)AzureProperties.getOrNull(AzureProperties.GROUP_NAME, this.properties);
        NetworkInterfaceOperations nicOps = this.networkManagement.getNetworkInterfacesOperations();
        for (NetworkInterfaceReference nir : profile.getNetworkInterfaces()) {
            String uri;
            String nicName;
            NetworkInterface nic;
            ArrayList ips;
            if (nir.isPrimary() != null && !nir.isPrimary().booleanValue() || (ips = (nic = nicOps.get(rgName, nicName = this.getResourceNameFromUri(uri = nir.getReferenceUri())).getNetworkInterface()).getIpConfigurations()).size() == 0) continue;
            NetworkInterfaceIpConfiguration ip = (NetworkInterfaceIpConfiguration)ips.get(0);
            Address privateAddress = new Address(ip.getPrivateIpAddress(), port);
            if (ip.getPublicIpAddress() != null) {
                String id = ip.getPublicIpAddress().getId();
                String pubIpName = this.getResourceNameFromUri(id);
                PublicIpAddress pubIp = pubOps.get(rgName, pubIpName).getPublicIpAddress();
                Address publicAddress = new Address(pubIp.getIpAddress(), port);
                if (this.getLocalHostAddress() != null && pubIp.getIpAddress().equals(this.getLocalHostAddress()) && pubIp.getDnsSettings() != null) {
                    String dnsDomainName = pubIp.getDnsSettings().getDomainNameLabel();
                    this.fetchVirtualMachineMetaData(faultDomainId, dnsDomainName);
                }
                return new SimpleDiscoveryNode(privateAddress, publicAddress);
            }
            if (this.getLocalHostAddress() != null && ip.getPrivateIpAddress().equals(this.getLocalHostAddress())) {
                this.fetchVirtualMachineMetaData(faultDomainId, null);
            }
            return new SimpleDiscoveryNode(privateAddress);
        }
        return null;
    }

    private void fetchVirtualMachineMetaData(String faultDomain, String dnsDomainName) {
        if (faultDomain != null) {
            this.memberMetaData.put("hazelcast.partition.group.zone", faultDomain);
        }
        if (dnsDomainName != null) {
            this.memberMetaData.put("hazelcast.partition.group.host", dnsDomainName);
        }
    }

    public String getLocalHostAddress() {
        try {
            InetAddress candidateAddress = null;
            Enumeration<java.net.NetworkInterface> ifaces = java.net.NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                java.net.NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr.getHostAddress();
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress.getHostAddress();
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress.getHostAddress();
        }
        catch (Exception e) {
            LOGGER.warning("Failed to determine Host address: " + e);
            return null;
        }
    }
}

