/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.azure;

import com.hazelcast.azure.AzureDiscoveryStrategy;
import com.hazelcast.azure.AzureProperties;
import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.DiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryStrategyFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class AzureDiscoveryStrategyFactory
implements DiscoveryStrategyFactory {
    private static final Collection<PropertyDefinition> PROPERTY_DEFINITIONS;

    public Class<? extends DiscoveryStrategy> getDiscoveryStrategyType() {
        return AzureDiscoveryStrategy.class;
    }

    public DiscoveryStrategy newDiscoveryStrategy(DiscoveryNode node, ILogger logger, Map<String, Comparable> properties) {
        for (PropertyDefinition prop : PROPERTY_DEFINITIONS) {
            if (AzureProperties.getOrNull(prop, properties) != null) continue;
            throw new IllegalArgumentException("Property, " + prop + " cannot be null");
        }
        return new AzureDiscoveryStrategy(properties);
    }

    public Collection<PropertyDefinition> getConfigurationProperties() {
        return PROPERTY_DEFINITIONS;
    }

    static {
        ArrayList<PropertyDefinition> propertyDefinitions = new ArrayList<PropertyDefinition>();
        propertyDefinitions.add(AzureProperties.CLIENT_ID);
        propertyDefinitions.add(AzureProperties.CLIENT_SECRET);
        propertyDefinitions.add(AzureProperties.SUBSCRIPTION_ID);
        propertyDefinitions.add(AzureProperties.TENANT_ID);
        propertyDefinitions.add(AzureProperties.GROUP_NAME);
        propertyDefinitions.add(AzureProperties.CLUSTER_ID);
        PROPERTY_DEFINITIONS = Collections.unmodifiableCollection(propertyDefinitions);
    }
}

