/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.azure;

import com.hazelcast.azure.RestClient;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.json.Json;

class AzureAuthenticator {
    private static final String AZURE_AUTH_ENDPOINT = "https://login.microsoftonline.com";
    private static final String RESOURCE = "https://management.azure.com";
    private static final String GRANT_TYPE = "client_credentials";
    private final String endpoint;

    AzureAuthenticator() {
        this.endpoint = AZURE_AUTH_ENDPOINT;
    }

    AzureAuthenticator(String endpoint) {
        this.endpoint = endpoint;
    }

    String refreshAccessToken(String tenantId, String clientId, String clientSecret) {
        try {
            String accessTokenJson = this.callService(this.urlFor(tenantId), this.body(clientId, clientSecret));
            return this.extractAccessToken(accessTokenJson);
        }
        catch (Exception e) {
            throw new HazelcastException("Error while fetching access token from Azure API", (Throwable)e);
        }
    }

    private String body(String clientId, String clientSecret) {
        return String.format("grant_type=%s&resource=%s&client_id=%s&client_secret=%s", GRANT_TYPE, RESOURCE, clientId, clientSecret);
    }

    private String urlFor(String tenantId) {
        return String.format("%s/%s/oauth2/token", this.endpoint, tenantId);
    }

    private String callService(String url, String body) {
        return RestClient.create(url).withBody(body).get();
    }

    private String extractAccessToken(String accessTokenJson) {
        return Json.parse((String)accessTokenJson).asObject().get("access_token").asString();
    }
}

