/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.azure;

import com.hazelcast.azure.RestClient;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonObject;
import java.util.HashMap;
import java.util.Map;

class AzureMetadataApi {
    static final String API_VERSION = "2018-02-01";
    static final String RESOURCE = "https://management.azure.com";
    private static final String METADATA_ENDPOINT = "http://169.254.169.254";
    private final String endpoint;
    private final Map<String, String> metadata;

    AzureMetadataApi() {
        this.endpoint = METADATA_ENDPOINT;
        this.metadata = new HashMap<String, String>();
    }

    AzureMetadataApi(String endpoint, Map<String, String> metadata) {
        this.endpoint = endpoint;
        this.metadata = metadata;
    }

    String subscriptionId() {
        return this.getMetadataProperty("subscriptionId");
    }

    String resourceGroupName() {
        return this.getMetadataProperty("resourceGroupName");
    }

    String location() {
        return this.getMetadataProperty("location");
    }

    String availabilityZone() {
        return this.getMetadataProperty("zone");
    }

    String faultDomain() {
        return this.getMetadataProperty("platformFaultDomain");
    }

    String scaleSet() {
        return this.getMetadataProperty("vmScaleSetName");
    }

    private String getMetadataProperty(String property) {
        this.fillMetadata();
        return this.metadata.get(property);
    }

    private void fillMetadata() {
        if (this.metadata.isEmpty()) {
            String urlString = String.format("%s/metadata/instance/compute?api-version=%s", this.endpoint, API_VERSION);
            String response = this.callGet(urlString);
            JsonObject jsonObject = Json.parse((String)response).asObject();
            for (String property : jsonObject.names()) {
                if (!jsonObject.get(property).isString()) continue;
                this.metadata.put(property, jsonObject.get(property).asString());
            }
        }
    }

    String accessToken() {
        String urlString = String.format("%s/metadata/identity/oauth2/token?api-version=%s&resource=%s", this.endpoint, API_VERSION, RESOURCE);
        String accessTokenResponse = this.callGet(urlString);
        return this.extractAccessToken(accessTokenResponse);
    }

    private String callGet(String urlString) {
        return RestClient.create(urlString).withHeader("Metadata", "true").get();
    }

    private String extractAccessToken(String accessTokenResponse) {
        return Json.parse((String)accessTokenResponse).asObject().get("access_token").asString();
    }
}

