/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.nearcache.NearCacheRecord;
import com.hazelcast.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClientHeapNearCache<K>
implements NearCache<K, Object> {
    private static final double EVICTION_FACTOR = 0.2;
    private static final int TTL_CLEANUP_INTERVAL_MILLS = 5000;
    private final int maxSize;
    private final long maxIdleMillis;
    private final long timeToLiveMillis;
    private final boolean invalidateOnChange;
    private final EvictionPolicy evictionPolicy;
    private final InMemoryFormat inMemoryFormat;
    private final String mapName;
    private final ClientContext context;
    private final AtomicBoolean canCleanUp;
    private final AtomicBoolean canEvict;
    private final ConcurrentMap<K, NearCacheRecord> cache;
    private final NearCacheStatsImpl stats;
    private final Comparator<NearCacheRecord> selectedComparator;
    private volatile long lastCleanup;

    public ClientHeapNearCache(String mapName, ClientContext context, NearCacheConfig nearCacheConfig) {
        this.mapName = mapName;
        this.context = context;
        this.maxSize = nearCacheConfig.getMaxSize();
        this.maxIdleMillis = TimeUnit.SECONDS.toMillis(nearCacheConfig.getMaxIdleSeconds());
        this.inMemoryFormat = nearCacheConfig.getInMemoryFormat();
        if (this.inMemoryFormat != InMemoryFormat.BINARY && this.inMemoryFormat != InMemoryFormat.OBJECT) {
            throw new IllegalArgumentException("Illegal in-memory-format: " + this.inMemoryFormat);
        }
        this.timeToLiveMillis = TimeUnit.SECONDS.toMillis(nearCacheConfig.getTimeToLiveSeconds());
        this.invalidateOnChange = nearCacheConfig.isInvalidateOnChange();
        this.evictionPolicy = EvictionPolicy.valueOf((String)nearCacheConfig.getEvictionPolicy());
        this.selectedComparator = NearCacheRecord.getComparator((EvictionPolicy)this.evictionPolicy);
        this.cache = new ConcurrentHashMap<K, NearCacheRecord>();
        this.canCleanUp = new AtomicBoolean(true);
        this.canEvict = new AtomicBoolean(true);
        this.lastCleanup = Clock.currentTimeMillis();
        this.stats = new NearCacheStatsImpl();
    }

    public void put(K key, Object object) {
        Object value;
        this.fireTtlCleanup();
        if (this.evictionPolicy == EvictionPolicy.NONE && this.cache.size() >= this.maxSize) {
            return;
        }
        if (this.evictionPolicy != EvictionPolicy.NONE && this.cache.size() >= this.maxSize) {
            this.fireEvictCache();
        }
        if (object == null) {
            value = NULL_OBJECT;
        } else {
            SerializationService serializationService = this.context.getSerializationService();
            if (this.inMemoryFormat == InMemoryFormat.BINARY) {
                value = serializationService.toData(object);
            } else if (this.inMemoryFormat == InMemoryFormat.OBJECT) {
                value = serializationService.toObject(object);
            } else {
                throw new IllegalArgumentException();
            }
        }
        this.cache.put(key, new NearCacheRecord(key, value));
    }

    private void fireEvictCache() {
        if (this.canEvict.compareAndSet(true, false)) {
            try {
                final ClientExecutionServiceImpl executionService = (ClientExecutionServiceImpl)this.context.getExecutionService();
                executionService.executeInternal(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            TreeSet records = new TreeSet(ClientHeapNearCache.this.selectedComparator);
                            records.addAll(ClientHeapNearCache.this.cache.values());
                            int evictSize = (int)((double)ClientHeapNearCache.this.cache.size() * 0.2);
                            int i = 0;
                            for (NearCacheRecord record : records) {
                                ClientHeapNearCache.this.cache.remove(record.getKey());
                                if (++i <= evictSize) continue;
                                break;
                            }
                        }
                        finally {
                            ClientHeapNearCache.this.canEvict.set(true);
                        }
                        if (ClientHeapNearCache.this.cache.size() >= ClientHeapNearCache.this.maxSize && ClientHeapNearCache.this.canEvict.compareAndSet(true, false)) {
                            try {
                                executionService.executeInternal(this);
                            }
                            catch (RejectedExecutionException e) {
                                ClientHeapNearCache.this.canEvict.set(true);
                            }
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.canEvict.set(true);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
    }

    private void fireTtlCleanup() {
        if (Clock.currentTimeMillis() < this.lastCleanup + 5000L) {
            return;
        }
        if (this.canCleanUp.compareAndSet(true, false)) {
            try {
                ClientExecutionServiceImpl executionService = (ClientExecutionServiceImpl)this.context.getExecutionService();
                executionService.executeInternal(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            ClientHeapNearCache.this.lastCleanup = Clock.currentTimeMillis();
                            for (Map.Entry entry : ClientHeapNearCache.this.cache.entrySet()) {
                                if (!((NearCacheRecord)entry.getValue()).isExpired(ClientHeapNearCache.this.maxIdleMillis, ClientHeapNearCache.this.timeToLiveMillis)) continue;
                                ClientHeapNearCache.this.cache.remove(entry.getKey());
                            }
                        }
                        finally {
                            ClientHeapNearCache.this.canCleanUp.set(true);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.canCleanUp.set(true);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
    }

    public String getName() {
        return this.mapName;
    }

    public Object get(K key) {
        this.fireTtlCleanup();
        NearCacheRecord record = (NearCacheRecord)this.cache.get(key);
        if (record != null) {
            record.access();
            if (record.isExpired(this.maxIdleMillis, this.timeToLiveMillis)) {
                this.cache.remove(key);
                this.stats.incrementMisses();
                return null;
            }
            if (record.getValue().equals(NULL_OBJECT)) {
                this.stats.incrementMisses();
                return NULL_OBJECT;
            }
            this.stats.incrementHits();
            return this.inMemoryFormat.equals((Object)InMemoryFormat.BINARY) ? this.context.getSerializationService().toObject(record.getValue()) : record.getValue();
        }
        this.stats.incrementMisses();
        return null;
    }

    public boolean remove(K key) {
        return null != this.cache.remove(key);
    }

    public NearCacheStatsImpl getNearCacheStats() {
        long ownedEntryCount = 0L;
        long ownedEntryMemory = 0L;
        for (NearCacheRecord record : this.cache.values()) {
            ++ownedEntryCount;
            ownedEntryMemory += record.getCost();
        }
        this.stats.setOwnedEntryCount(ownedEntryCount);
        this.stats.setOwnedEntryMemoryCost(ownedEntryMemory);
        return this.stats;
    }

    public Object selectToSave(Object ... candidates) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.cache.size();
    }

    public void clear() {
        this.cache.clear();
    }

    public void destroy() {
        this.cache.clear();
    }

    public boolean isInvalidateOnChange() {
        return this.invalidateOnChange;
    }

    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }
}

