/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn.proxy.xa;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.client.CommitXATransactionRequest;
import com.hazelcast.transaction.client.CreateXATransactionRequest;
import com.hazelcast.transaction.client.PrepareXATransactionRequest;
import com.hazelcast.transaction.client.RollbackXATransactionRequest;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.xa.SerializableXID;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class XATransactionProxy {
    private final HazelcastClientInstanceImpl client;
    private final ClientConnection connection;
    private final SerializableXID xid;
    private final int timeout;
    private Transaction.State state = Transaction.State.NO_TXN;
    private volatile String txnId;
    private long startTime;

    public XATransactionProxy(HazelcastClientInstanceImpl client, ClientConnection connection, Xid xid, int timeout) {
        this.client = client;
        this.connection = connection;
        this.timeout = timeout;
        this.xid = new SerializableXID(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    void begin() {
        try {
            this.startTime = Clock.currentTimeMillis();
            this.txnId = (String)this.invoke((ClientRequest)new CreateXATransactionRequest(this.xid, this.timeout));
            this.state = Transaction.State.ACTIVE;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    void prepare() {
        this.checkTimeout();
        try {
            if (this.state != Transaction.State.ACTIVE) {
                throw new TransactionNotActiveException("Transaction is not active");
            }
            PrepareXATransactionRequest request = new PrepareXATransactionRequest(this.txnId);
            this.invoke((ClientRequest)request);
            this.state = Transaction.State.PREPARED;
        }
        catch (Exception e) {
            this.state = Transaction.State.ROLLING_BACK;
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    void commit(boolean onePhase) {
        this.checkTimeout();
        try {
            if (onePhase && this.state != Transaction.State.ACTIVE) {
                throw new TransactionException("Transaction is not active");
            }
            if (!onePhase && this.state != Transaction.State.PREPARED) {
                throw new TransactionException("Transaction is not prepared");
            }
            this.invoke((ClientRequest)new CommitXATransactionRequest(this.txnId, onePhase));
            this.state = Transaction.State.COMMITTED;
        }
        catch (Exception e) {
            this.state = Transaction.State.ROLLING_BACK;
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    void rollback() {
        try {
            RollbackXATransactionRequest request = new RollbackXATransactionRequest(this.txnId);
            this.invoke((ClientRequest)request);
        }
        catch (Exception ignored) {
            EmptyStatement.ignore((Throwable)ignored);
        }
        this.state = Transaction.State.ROLLED_BACK;
    }

    public String getTxnId() {
        return this.txnId;
    }

    public Transaction.State getState() {
        return this.state;
    }

    private void checkTimeout() {
        long timeoutMillis = TimeUnit.SECONDS.toMillis(this.timeout);
        if (this.startTime + timeoutMillis < Clock.currentTimeMillis()) {
            ExceptionUtil.sneakyThrow((Throwable)new XAException(106));
        }
    }

    private <T> T invoke(ClientRequest request) {
        SerializationService ss = this.client.getSerializationService();
        try {
            ClientInvocation clientInvocation = new ClientInvocation(this.client, request, this.connection);
            ClientInvocationFuture future = clientInvocation.invoke();
            return (T)ss.toObject(future.get());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }
}

