/*
 * Copyright (c) 2008-2016, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.cache.impl;

import com.hazelcast.cache.ICache;

/**
 * Internal API for {@link com.hazelcast.cache.ICache} implementations.
 *
 * @param <K> the type of key.
 * @param <V> the type of value.
 * @see com.hazelcast.cache.ICache
 * @since 3.5
 */
public interface ICacheInternal<K, V>
        extends ICache<K, V> {

    /**
     * Opens cache if available (not destroyed).
     * If cache is already open, does nothing.
     *
     * @throws IllegalStateException if cache is already destroyed
     */
    void open();

}
