/*
 * Copyright (c) 2008-2016, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.map.impl;

import com.hazelcast.core.BaseMap;
import com.hazelcast.map.EntryProcessor;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

/**
 * Base interface for a {@link BaseMap} which provides additional {@link Future}-returning
 * *Async methods. This interface was added so that {@link com.hazelcast.core.IMap} extends these methods
 * with the narrower {@link com.hazelcast.core.ICompletableFuture} return type and
 * binary backwards compatibility is maintained with previous versions of {@link com.hazelcast.core.IMap}
 * which returned {@link Future} via bridge methods generated by the Java compiler.
 * See https://docs.oracle.com/javase/tutorial/java/generics/bridgeMethods.html for an explanation of
 * bridge methods.
 */
public interface LegacyAsyncMap<K, V> extends BaseMap<K, V> {

    Future<V> getAsync(K key);

    Future<V> putAsync(K key, V value);

    Future<V> putAsync(K key, V value, long ttl, TimeUnit timeunit);

    Future<Void> setAsync(K key, V value);

    Future<Void> setAsync(K key, V value, long ttl, TimeUnit timeunit);

    Future<V> removeAsync(K key);

    Future submitToKey(K key, EntryProcessor entryProcessor);
}
