/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncClientCall<V>
implements Future<V> {
    private Object result = null;
    private static final Object NULL = new Object();
    private final Call remoteCall;

    public AsyncClientCall(Call remoteCall) {
        this.remoteCall = remoteCall;
    }

    public void setResult(Object obj) {
        if (obj == null) {
            obj = NULL;
        }
        this.result = obj;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (this.result != null) {
            return this.getResult();
        }
        this.setResult(this.remoteCall.getResponse());
        return this.getResult();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.result != null) {
            return this.getResult();
        }
        this.setResult(this.remoteCall.getResponse(timeout, unit));
        return this.getResult();
    }

    private V getResult() throws ExecutionException {
        if (this.result == NULL) {
            return null;
        }
        if (this.result instanceof Throwable) {
            throw new ExecutionException((Throwable)this.result);
        }
        return (V)this.result;
    }
}

