/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.Connection;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.IORunnable;
import com.hazelcast.client.OutRunnable;
import com.hazelcast.client.Packet;
import com.hazelcast.client.PacketReader;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;

public class InRunnable
extends IORunnable
implements Runnable {
    final PacketReader reader;
    Connection connection = null;
    private final OutRunnable outRunnable;
    volatile long lastReceived;

    public InRunnable(HazelcastClient client, OutRunnable outRunnable, Map<Long, Call> calls, PacketReader reader) {
        super(client, calls);
        this.outRunnable = outRunnable;
        this.reader = reader;
    }

    @Override
    protected void customRun() throws InterruptedException {
        if (this.outRunnable.reconnection.get()) {
            Thread.sleep(10L);
            return;
        }
        try {
            Connection oldConnection = this.connection;
            this.connection = this.client.connectionManager.getConnection();
            if (this.restoredConnection(oldConnection, this.connection)) {
                if (this.outRunnable.sendReconnectCall(this.connection)) {
                    this.logger.log(Level.FINEST, "restoredConnection");
                    if (oldConnection != null) {
                        this.redoUnfinishedCalls(oldConnection);
                    }
                }
                return;
            }
            if (this.connection == null) {
                this.outRunnable.clusterIsDown(oldConnection);
                Thread.sleep(10L);
            } else {
                Packet packet = this.reader.readPacket(this.connection);
                this.lastReceived = Clock.currentTimeMillis();
                Call call = (Call)this.callMap.remove(packet.getCallId());
                if (call != null) {
                    call.received = System.nanoTime();
                    call.setResponse(packet);
                } else {
                    if (packet.getOperation().equals((Object)ClusterOperation.EVENT)) {
                        this.client.getListenerManager().enqueue(packet);
                    }
                    if (packet.getCallId() != -1L) {
                        this.logger.log(Level.SEVERE, "In Thread can not handle: " + packet.getOperation() + " : " + packet.getCallId());
                    }
                }
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.FINEST, "InRunnable [" + this.connection + "] got an exception:" + e.toString(), e);
            this.outRunnable.clusterIsDown(this.connection);
        }
    }

    private void redoUnfinishedCalls(Connection oldConnection) {
        this.onDisconnect(oldConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.running) {
                this.running = false;
                try {
                    Connection connection = this.client.connectionManager.getConnection();
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                try {
                    this.monitor.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

