/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClientManagedContext;
import com.hazelcast.client.HazelcastClientProxy;
import com.hazelcast.client.LifecycleServiceImpl;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.DummyClientConnectionManager;
import com.hazelcast.client.connection.SmartClientConnectionManager;
import com.hazelcast.client.proxy.ClientClusterProxy;
import com.hazelcast.client.proxy.PartitionServiceProxy;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.ProxyManager;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocationServiceImpl;
import com.hazelcast.client.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.client.txn.TransactionContextProxy;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionProxyType;
import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.PartitionService;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.serialization.SerializationServiceBuilder;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import com.hazelcast.transaction.TransactionalTaskContext;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class HazelcastClient
implements HazelcastInstance {
    private static final AtomicInteger CLIENT_ID = new AtomicInteger();
    private static final ConcurrentMap<Integer, HazelcastClientProxy> CLIENTS = new ConcurrentHashMap<Integer, HazelcastClientProxy>(5);
    private final int id = CLIENT_ID.getAndIncrement();
    private final String name;
    private final ClientConfig config;
    private final ThreadGroup threadGroup;
    private final LifecycleServiceImpl lifecycleService;
    private final SerializationService serializationService;
    private final ClientConnectionManager connectionManager;
    private final ClientClusterServiceImpl clusterService;
    private final ClientPartitionServiceImpl partitionService;
    private final ClientInvocationServiceImpl invocationService;
    private final ClientExecutionServiceImpl executionService;
    private final ProxyManager proxyManager;
    private final ConcurrentMap<String, Object> userContext;

    private HazelcastClient(ClientConfig config) {
        SerializationService ss;
        this.config = config;
        GroupConfig groupConfig = config.getGroupConfig();
        this.name = "hz.client_" + this.id + (groupConfig != null ? "_" + groupConfig.getName() : "");
        this.threadGroup = new ThreadGroup(this.name);
        this.lifecycleService = new LifecycleServiceImpl(this);
        try {
            ss = new SerializationServiceBuilder().setManagedContext((ManagedContext)new HazelcastClientManagedContext(this, config.getManagedContext())).setClassLoader(config.getClassLoader()).setConfig(config.getSerializationConfig()).build();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        this.serializationService = ss;
        this.proxyManager = new ProxyManager(this);
        this.executionService = new ClientExecutionServiceImpl(this.name, this.threadGroup, Thread.currentThread().getContextClassLoader());
        this.clusterService = new ClientClusterServiceImpl(this);
        LoadBalancer loadBalancer = config.getLoadBalancer();
        if (loadBalancer == null) {
            loadBalancer = new RoundRobinLB();
        }
        this.connectionManager = config.isSmart() ? new SmartClientConnectionManager(this, this.clusterService.getAuthenticator(), loadBalancer) : new DummyClientConnectionManager(this, this.clusterService.getAuthenticator(), loadBalancer);
        this.invocationService = new ClientInvocationServiceImpl(this);
        this.userContext = new ConcurrentHashMap<String, Object>();
        this.clusterService.start();
        loadBalancer.init(this.getCluster(), config);
        this.proxyManager.init(config.getProxyFactoryConfig());
        this.lifecycleService.setStarted();
        this.partitionService = new ClientPartitionServiceImpl(this);
        this.partitionService.start();
    }

    public static HazelcastInstance newHazelcastClient() {
        return HazelcastClient.newHazelcastClient(new XmlClientConfigBuilder().build());
    }

    public static HazelcastInstance newHazelcastClient(ClientConfig config) {
        if (config == null) {
            config = new XmlClientConfigBuilder().build();
        }
        HazelcastClient client = new HazelcastClient(config);
        HazelcastClientProxy proxy = new HazelcastClientProxy(client);
        CLIENTS.put(client.id, proxy);
        return proxy;
    }

    public Config getConfig() {
        throw new UnsupportedOperationException("Client cannot access cluster config!");
    }

    public String getName() {
        return this.name;
    }

    public <E> IQueue<E> getQueue(String name) {
        return (IQueue)this.getDistributedObject("hz:impl:queueService", name);
    }

    public <E> ITopic<E> getTopic(String name) {
        return (ITopic)this.getDistributedObject("hz:impl:topicService", name);
    }

    public <E> ISet<E> getSet(String name) {
        return (ISet)this.getDistributedObject("hz:impl:collectionService", new CollectionProxyId("hz:set:", name, CollectionProxyType.SET));
    }

    public <E> IList<E> getList(String name) {
        return (IList)this.getDistributedObject("hz:impl:collectionService", new CollectionProxyId("hz:list:", name, CollectionProxyType.LIST));
    }

    public <K, V> IMap<K, V> getMap(String name) {
        return (IMap)this.getDistributedObject("hz:impl:mapService", name);
    }

    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return (MultiMap)this.getDistributedObject("hz:impl:collectionService", new CollectionProxyId(name, null, CollectionProxyType.MULTI_MAP));
    }

    public ILock getLock(Object key) {
        return (ILock)this.getDistributedObject("hz:impl:lockService", key);
    }

    public Cluster getCluster() {
        return new ClientClusterProxy(this.clusterService);
    }

    public IExecutorService getExecutorService(String name) {
        return (IExecutorService)this.getDistributedObject("hz:impl:executorService", name);
    }

    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.executeTransaction(TransactionOptions.getDefault(), task);
    }

    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        TransactionContext context = this.newTransactionContext(options);
        context.beginTransaction();
        try {
            Object value = task.execute((TransactionalTaskContext)context);
            context.commitTransaction();
            return (T)value;
        }
        catch (Throwable e) {
            context.rollbackTransaction();
            if (e instanceof TransactionException) {
                throw (TransactionException)e;
            }
            if (e.getCause() instanceof TransactionException) {
                throw (TransactionException)e.getCause();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionException(e);
        }
    }

    public TransactionContext newTransactionContext() {
        return this.newTransactionContext(TransactionOptions.getDefault());
    }

    public TransactionContext newTransactionContext(TransactionOptions options) {
        return new TransactionContextProxy(this, options);
    }

    public IdGenerator getIdGenerator(String name) {
        return (IdGenerator)this.getDistributedObject("hz:impl:idGeneratorService", name);
    }

    public IAtomicLong getAtomicLong(String name) {
        return (IAtomicLong)this.getDistributedObject("hz:impl:atomicLongService", name);
    }

    public ICountDownLatch getCountDownLatch(String name) {
        return (ICountDownLatch)this.getDistributedObject("hz:impl:countDownLatchService", name);
    }

    public ISemaphore getSemaphore(String name) {
        return (ISemaphore)this.getDistributedObject("hz:impl:semaphoreService", name);
    }

    public Collection<DistributedObject> getDistributedObjects() {
        LinkedList<DistributedObject> objects = new LinkedList<DistributedObject>();
        for (ClientProxy clientProxy : this.proxyManager.getProxies()) {
            objects.add(clientProxy);
        }
        return objects;
    }

    public String addDistributedObjectListener(DistributedObjectListener distributedObjectListener) {
        return this.proxyManager.addDistributedObjectListener(distributedObjectListener);
    }

    public boolean removeDistributedObjectListener(String registrationId) {
        return this.proxyManager.removeDistributedObjectListener(registrationId);
    }

    public PartitionService getPartitionService() {
        return new PartitionServiceProxy(this.partitionService);
    }

    public ClientService getClientService() {
        throw new UnsupportedOperationException();
    }

    public LoggingService getLoggingService() {
        throw new UnsupportedOperationException();
    }

    public LifecycleService getLifecycleService() {
        return this.lifecycleService;
    }

    public <T extends DistributedObject> T getDistributedObject(String serviceName, Object id) {
        return (T)this.proxyManager.getProxy(serviceName, id);
    }

    public ConcurrentMap<String, Object> getUserContext() {
        return this.userContext;
    }

    public ClientConfig getClientConfig() {
        return this.config;
    }

    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    public ClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ClientClusterService getClientClusterService() {
        return this.clusterService;
    }

    public ClientExecutionService getClientExecutionService() {
        return this.executionService;
    }

    public ClientPartitionService getClientPartitionService() {
        return this.partitionService;
    }

    public ClientInvocationService getInvocationService() {
        return this.invocationService;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    void shutdown() {
        CLIENTS.remove(this.id);
        this.executionService.shutdown();
        this.partitionService.stop();
        this.clusterService.stop();
        this.connectionManager.shutdown();
    }

    public static Collection<HazelcastInstance> getAllHazelcastClients() {
        return Collections.unmodifiableCollection(CLIENTS.values());
    }

    public static void shutdownAll() {
        for (HazelcastClientProxy proxy : CLIENTS.values()) {
            try {
                proxy.client.getLifecycleService().shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            proxy.client = null;
        }
        CLIENTS.clear();
    }
}

