/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection;

import com.hazelcast.client.connection.Connection;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.cluster.client.ClientPingRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class HeartBeatChecker {
    private final int connectionTimeout;
    private final ClientExecutionService executionService;
    private final Data ping;

    public HeartBeatChecker(int timeout, SerializationService serializationService, ClientExecutionService executionService) {
        this.connectionTimeout = timeout;
        this.executionService = executionService;
        this.ping = serializationService.toData((Object)new ClientPingRequest());
    }

    public boolean checkHeartBeat(final Connection connection) {
        if (Clock.currentTimeMillis() - connection.getLastReadTime() > (long)(this.connectionTimeout / 2)) {
            final CountDownLatch latch = new CountDownLatch(1);
            this.executionService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        connection.write(HeartBeatChecker.this.ping);
                        connection.read();
                        latch.countDown();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            try {
                return latch.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return true;
    }
}

