/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi;

import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.ListenerSupport;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.nio.serialization.Data;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ClientProxy
implements DistributedObject {
    private final String serviceName;
    private final Object objectId;
    private volatile ClientContext context;
    private final Map<String, ListenerSupport> listenerSupportMap = new ConcurrentHashMap<String, ListenerSupport>();

    protected ClientProxy(String serviceName, Object objectId) {
        this.serviceName = serviceName;
        this.objectId = objectId;
    }

    protected final String listen(Object registrationRequest, Data key, EventHandler handler) {
        ListenerSupport listenerSupport = new ListenerSupport(this.context, registrationRequest, handler, key);
        String registrationId = listenerSupport.listen();
        this.listenerSupportMap.put(registrationId, listenerSupport);
        return registrationId;
    }

    protected final String listen(Object registrationRequest, EventHandler handler) {
        return this.listen(registrationRequest, null, handler);
    }

    protected final boolean stopListening(String registrationId) {
        ListenerSupport listenerSupport = this.listenerSupportMap.remove(registrationId);
        if (listenerSupport != null) {
            listenerSupport.stop();
            return true;
        }
        return false;
    }

    protected final ClientContext getContext() {
        ClientContext ctx = this.context;
        if (ctx == null) {
            throw new HazelcastInstanceNotActiveException();
        }
        return this.context;
    }

    final void setContext(ClientContext context) {
        this.context = context;
    }

    public final Object getId() {
        return this.objectId;
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final void destroy() {
        this.onDestroy();
        this.context.removeProxy(this);
        this.context = null;
    }

    protected abstract void onDestroy();
}

