/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.util.AddressUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public final class AddressHelper {
    public static Collection<InetSocketAddress> getSocketAddresses(String address) {
        AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder((String)address, (int)5701);
        String scopedAddress = addressHolder.scopeId != null ? addressHolder.address + "%" + addressHolder.scopeId : addressHolder.address;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(scopedAddress);
        }
        catch (UnknownHostException ignored) {
            // empty catch block
        }
        if (inetAddress == null) {
            return Collections.singleton(new InetSocketAddress(scopedAddress, addressHolder.port));
        }
        return AddressHelper.getPossibleSocketAddresses(inetAddress, addressHolder.port);
    }

    public static Collection<InetSocketAddress> getPossibleSocketAddresses(InetAddress inetAddress, int port) {
        if (inetAddress == null) {
            return Collections.emptySet();
        }
        if (inetAddress instanceof Inet4Address) {
            return Collections.singleton(new InetSocketAddress(inetAddress, port));
        }
        Collection addresses = AddressUtil.getPossibleInetAddressesFor((Inet6Address)((Inet6Address)inetAddress));
        LinkedList<InetSocketAddress> socketAddresses = new LinkedList<InetSocketAddress>();
        for (Inet6Address inet6Address : addresses) {
            socketAddresses.add(new InetSocketAddress(inet6Address, port));
        }
        return socketAddresses;
    }

    private AddressHelper() {
    }
}

