/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.util.Destructor;
import com.hazelcast.client.util.Factory;
import com.hazelcast.client.util.ObjectPool;
import com.hazelcast.core.HazelcastException;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class QueueBasedObjectPool<E>
implements ObjectPool<E> {
    private final BlockingQueue<E> queue;
    private final Factory<E> factory;
    private final Destructor<E> destructor;
    private volatile boolean active = true;

    public QueueBasedObjectPool(int capacity, Factory<E> factory, Destructor<E> destructor) {
        this.queue = new LinkedBlockingQueue(capacity);
        this.factory = factory;
        this.destructor = destructor;
    }

    @Override
    public E take() {
        if (!this.active) {
            return null;
        }
        Object e = this.queue.poll();
        if (e == null) {
            try {
                e = this.factory.create();
            }
            catch (Exception ex) {
                throw new HazelcastException((Throwable)ex);
            }
        }
        return e;
    }

    @Override
    public void release(E e) {
        if (!this.active || !this.queue.offer(e)) {
            this.destructor.destroy(e);
        }
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public void destroy() {
        this.active = true;
        LinkedList c = new LinkedList();
        this.queue.drainTo(c);
        for (Object e : c) {
            this.destructor.destroy(e);
        }
    }
}

