/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.connection.Authenticator;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.Connection;
import com.hazelcast.client.connection.ConnectionImpl;
import com.hazelcast.client.connection.HeartBeatChecker;
import com.hazelcast.client.connection.Router;
import com.hazelcast.client.util.Destructor;
import com.hazelcast.client.util.Factory;
import com.hazelcast.client.util.ObjectPool;
import com.hazelcast.client.util.QueueBasedObjectPool;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ConstructorFunction;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

public class SmartClientConnectionManager
implements ClientConnectionManager {
    private static final ILogger logger = Logger.getLogger(ClientConnectionManager.class);
    private final int poolSize;
    private final Authenticator authenticator;
    private final HazelcastClient client;
    private final Router router;
    private final ConcurrentMap<Address, ObjectPool<ConnectionWrapper>> poolMap = new ConcurrentHashMap<Address, ObjectPool<ConnectionWrapper>>(16, 0.75f, 1);
    private final SocketOptions socketOptions;
    private final SocketInterceptor socketInterceptor;
    private final HeartBeatChecker heartbeat;
    private volatile boolean live = true;
    private final ConstructorFunction<Address, ObjectPool<ConnectionWrapper>> ctor = new ConstructorFunction<Address, ObjectPool<ConnectionWrapper>>(){

        public ObjectPool<ConnectionWrapper> createNew(final Address address) {
            return new QueueBasedObjectPool<ConnectionWrapper>(SmartClientConnectionManager.this.poolSize, new Factory<ConnectionWrapper>(){

                @Override
                public ConnectionWrapper create() throws IOException {
                    return new ConnectionWrapper(SmartClientConnectionManager.this.newConnection(address, SmartClientConnectionManager.this.authenticator));
                }
            }, new Destructor<ConnectionWrapper>(){

                @Override
                public void destroy(ConnectionWrapper connection) {
                    connection.close();
                }
            });
        }
    };

    public SmartClientConnectionManager(HazelcastClient client, Authenticator authenticator, LoadBalancer loadBalancer) {
        this.authenticator = authenticator;
        this.client = client;
        ClientConfig config = client.getClientConfig();
        this.router = new Router(loadBalancer);
        this.socketInterceptor = config.getSocketInterceptor();
        this.poolSize = config.getConnectionPoolSize();
        int connectionTimeout = config.getConnectionTimeout();
        this.heartbeat = new HeartBeatChecker(connectionTimeout, client.getSerializationService(), client.getClientExecutionService());
        this.socketOptions = config.getSocketOptions();
    }

    @Override
    public Connection firstConnection(Address address, Authenticator authenticator) throws IOException {
        return this.newConnection(address, authenticator);
    }

    @Override
    public Connection newConnection(Address address, Authenticator authenticator) throws IOException {
        this.checkLive();
        ConnectionImpl connection = new ConnectionImpl(address, this.socketOptions, this.client.getSerializationService());
        connection.write("CB1".getBytes());
        connection.write("JVM".getBytes());
        if (this.socketInterceptor != null) {
            this.socketInterceptor.onConnect(connection.getSocket());
        }
        authenticator.auth(connection);
        return connection;
    }

    @Override
    public Connection getRandomConnection() throws IOException {
        this.checkLive();
        Address address = this.router.next();
        if (address == null) {
            throw new IOException("LoadBalancer '" + this.router + "' could not find a address to route to");
        }
        return this.getConnection(address);
    }

    @Override
    public Connection getConnection(Address address) throws IOException {
        this.checkLive();
        if (address == null) {
            throw new IllegalArgumentException("Target address is required!");
        }
        ObjectPool<ConnectionWrapper> pool = this.getConnectionPool(address);
        if (pool == null) {
            return null;
        }
        Connection connection = null;
        try {
            connection = pool.take();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error during connection creation...", (Throwable)e);
        }
        if (connection != null && !this.heartbeat.checkHeartBeat(connection)) {
            connection.close();
            connection = null;
        }
        return connection;
    }

    private void checkLive() {
        if (!this.live) {
            throw new HazelcastInstanceNotActiveException();
        }
    }

    private ObjectPool<ConnectionWrapper> getConnectionPool(Address address) {
        this.checkLive();
        ObjectPool pool = (ObjectPool)this.poolMap.get(address);
        if (pool == null) {
            if (this.client.getClientClusterService().getMember(address) == null) {
                return null;
            }
            pool = (ObjectPool)this.ctor.createNew((Object)address);
            ObjectPool current = this.poolMap.putIfAbsent(address, pool);
            pool = current == null ? pool : current;
        }
        return pool;
    }

    private void releaseConnection(ConnectionWrapper connection) {
        if (this.live) {
            ObjectPool pool = (ObjectPool)this.poolMap.get(connection.getEndpoint());
            if (pool != null) {
                pool.release(connection);
            } else {
                connection.close();
            }
        } else {
            connection.close();
        }
    }

    @Override
    public void removeConnectionPool(Address address) {
        ObjectPool pool = (ObjectPool)this.poolMap.remove(address);
        if (pool != null) {
            pool.destroy();
        }
    }

    @Override
    public void shutdown() {
        this.live = false;
        for (ObjectPool pool : this.poolMap.values()) {
            pool.destroy();
        }
        this.poolMap.clear();
    }

    private class ConnectionWrapper
    implements Connection {
        final Connection connection;

        private ConnectionWrapper(Connection connection) {
            this.connection = connection;
        }

        @Override
        public Address getEndpoint() {
            return this.connection.getEndpoint();
        }

        @Override
        public boolean write(Data data) throws IOException {
            return this.connection.write(data);
        }

        @Override
        public Data read() throws IOException {
            return this.connection.read();
        }

        @Override
        public void release() throws IOException {
            SmartClientConnectionManager.this.releaseConnection(this);
        }

        @Override
        public void close() {
            IOUtil.closeResource((Closeable)this.connection);
        }

        @Override
        public int getId() {
            return this.connection.getId();
        }

        @Override
        public long getLastReadTime() {
            return this.connection.getLastReadTime();
        }

        @Override
        public void setEndpoint(Address address) {
            this.connection.setEndpoint(address);
        }

        public String toString() {
            return this.connection.toString();
        }
    }
}

