/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.concurrent.atomiclong.client.AddAndGetRequest;
import com.hazelcast.concurrent.atomiclong.client.AtomicLongDestroyRequest;
import com.hazelcast.concurrent.atomiclong.client.CompareAndSetRequest;
import com.hazelcast.concurrent.atomiclong.client.GetAndAddRequest;
import com.hazelcast.concurrent.atomiclong.client.GetAndSetRequest;
import com.hazelcast.concurrent.atomiclong.client.SetRequest;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;

public class ClientAtomicLongProxy
extends ClientProxy
implements IAtomicLong {
    private final String name;
    private Data key;

    public ClientAtomicLongProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
        this.name = objectId;
    }

    public long addAndGet(long delta) {
        AddAndGetRequest request = new AddAndGetRequest(this.name, delta);
        Long result = (Long)this.invoke(request);
        return result;
    }

    public boolean compareAndSet(long expect, long update) {
        CompareAndSetRequest request = new CompareAndSetRequest(this.name, expect, update);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    public long decrementAndGet() {
        return this.addAndGet(-1L);
    }

    public long get() {
        return this.getAndAdd(0L);
    }

    public long getAndAdd(long delta) {
        GetAndAddRequest request = new GetAndAddRequest(this.name, delta);
        Long result = (Long)this.invoke(request);
        return result;
    }

    public long getAndSet(long newValue) {
        GetAndSetRequest request = new GetAndSetRequest(this.name, newValue);
        Long result = (Long)this.invoke(request);
        return result;
    }

    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    public long getAndIncrement() {
        return this.getAndAdd(1L);
    }

    public void set(long newValue) {
        SetRequest request = new SetRequest(this.name, newValue);
        this.invoke(request);
    }

    @Override
    protected void onDestroy() {
        AtomicLongDestroyRequest request = new AtomicLongDestroyRequest(this.name);
        this.invoke(request);
    }

    public String getName() {
        return this.name;
    }

    private <T> T invoke(Object req) {
        try {
            return this.getContext().getInvocationService().invokeOnKeyOwner(req, this.getKey());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private Data getKey() {
        if (this.key == null) {
            this.key = this.getContext().getSerializationService().toData((Object)this.name);
        }
        return this.key;
    }
}

