/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.util.AddressUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.LinkedList;

public final class AddressHelper {
    private static final int MAX_PORT_TRIES = 3;

    public static Collection<InetSocketAddress> getSocketAddresses(String address) {
        AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder((String)address, (int)-1);
        String scopedAddress = addressHolder.scopeId != null ? addressHolder.address + "%" + addressHolder.scopeId : addressHolder.address;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(scopedAddress);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return AddressHelper.getPossibleSocketAddresses(inetAddress, addressHolder.port, scopedAddress);
    }

    public static Collection<InetSocketAddress> getPossibleSocketAddresses(InetAddress inetAddress, int port, String scopedAddress) {
        int portTryCount = 1;
        if (port == -1) {
            portTryCount = 3;
            port = 5701;
        }
        LinkedList<InetSocketAddress> socketAddresses = new LinkedList<InetSocketAddress>();
        if (inetAddress == null) {
            for (int i = 0; i < portTryCount; ++i) {
                socketAddresses.add(new InetSocketAddress(scopedAddress, port + i));
            }
        } else if (inetAddress instanceof Inet4Address) {
            for (int i = 0; i < portTryCount; ++i) {
                socketAddresses.add(new InetSocketAddress(inetAddress, port + i));
            }
        } else {
            Collection addresses = AddressUtil.getPossibleInetAddressesFor((Inet6Address)((Inet6Address)inetAddress));
            for (Inet6Address inet6Address : addresses) {
                for (int i = 0; i < portTryCount; ++i) {
                    socketAddresses.add(new InetSocketAddress(inet6Address, port + i));
                }
            }
        }
        return socketAddresses;
    }

    private AddressHelper() {
    }
}

