/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.client.impl.ClientLockReferenceIdGenerator;
import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddEntryListenerToKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddEntryListenerToKeyWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddEntryListenerWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddIndexCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddInterceptorCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddPartitionLostListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapAggregateCodec;
import com.hazelcast.client.impl.protocol.codec.MapAggregateWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapClearCodec;
import com.hazelcast.client.impl.protocol.codec.MapContainsKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MapContainsValueCodec;
import com.hazelcast.client.impl.protocol.codec.MapDeleteCodec;
import com.hazelcast.client.impl.protocol.codec.MapEntriesWithPagingPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapEntriesWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapEntrySetCodec;
import com.hazelcast.client.impl.protocol.codec.MapEventJournalReadCodec;
import com.hazelcast.client.impl.protocol.codec.MapEventJournalSubscribeCodec;
import com.hazelcast.client.impl.protocol.codec.MapEvictAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapEvictCodec;
import com.hazelcast.client.impl.protocol.codec.MapExecuteOnAllKeysCodec;
import com.hazelcast.client.impl.protocol.codec.MapExecuteOnKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MapExecuteOnKeysCodec;
import com.hazelcast.client.impl.protocol.codec.MapExecuteWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapFlushCodec;
import com.hazelcast.client.impl.protocol.codec.MapForceUnlockCodec;
import com.hazelcast.client.impl.protocol.codec.MapGetAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapGetCodec;
import com.hazelcast.client.impl.protocol.codec.MapGetEntryViewCodec;
import com.hazelcast.client.impl.protocol.codec.MapIsEmptyCodec;
import com.hazelcast.client.impl.protocol.codec.MapIsLockedCodec;
import com.hazelcast.client.impl.protocol.codec.MapKeySetCodec;
import com.hazelcast.client.impl.protocol.codec.MapKeySetWithPagingPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapKeySetWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapLoadAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapLoadGivenKeysCodec;
import com.hazelcast.client.impl.protocol.codec.MapLockCodec;
import com.hazelcast.client.impl.protocol.codec.MapProjectCodec;
import com.hazelcast.client.impl.protocol.codec.MapProjectWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutIfAbsentCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutTransientCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveIfSameCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveInterceptorCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemovePartitionLostListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapReplaceCodec;
import com.hazelcast.client.impl.protocol.codec.MapReplaceIfSameCodec;
import com.hazelcast.client.impl.protocol.codec.MapSetCodec;
import com.hazelcast.client.impl.protocol.codec.MapSizeCodec;
import com.hazelcast.client.impl.protocol.codec.MapSubmitToKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MapTryLockCodec;
import com.hazelcast.client.impl.protocol.codec.MapTryPutCodec;
import com.hazelcast.client.impl.protocol.codec.MapTryRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.MapUnlockCodec;
import com.hazelcast.client.impl.protocol.codec.MapValuesCodec;
import com.hazelcast.client.impl.protocol.codec.MapValuesWithPagingPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapValuesWithPredicateCodec;
import com.hazelcast.client.impl.querycache.ClientQueryCacheContext;
import com.hazelcast.client.impl.querycache.subscriber.ClientQueryCacheEndToEndConstructor;
import com.hazelcast.client.map.impl.ClientMapPartitionIterator;
import com.hazelcast.client.map.impl.ClientMapQueryPartitionIterator;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IMapEvent;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.ReadOnly;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.ResultSet;
import com.hazelcast.journal.EventJournalInitialSubscriberState;
import com.hazelcast.journal.EventJournalReader;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapPartitionLostEvent;
import com.hazelcast.map.QueryCache;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.map.impl.LazyMapEntry;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.ListenerAdapters;
import com.hazelcast.map.impl.MapListenerFlagOperator;
import com.hazelcast.map.impl.SimpleEntryView;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheEndToEndProvider;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheRequest;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheRequests;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberContext;
import com.hazelcast.map.journal.EventJournalMapEvent;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.MappingJob;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.mapreduce.ReducingSubmittableJob;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.PartitionPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.ringbuffer.ReadResultSet;
import com.hazelcast.ringbuffer.impl.client.PortableReadResultSet;
import com.hazelcast.spi.impl.UnmodifiableLazyList;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.SortingUtil;
import com.hazelcast.util.ThreadUtil;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.util.collection.InflatableSet;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ClientMapProxy<K, V>
extends ClientProxy
implements IMap<K, V>,
EventJournalReader<EventJournalMapEvent<K, V>> {
    protected static final String NULL_LISTENER_IS_NOT_ALLOWED = "Null listener is not allowed!";
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    protected static final String NULL_PREDICATE_IS_NOT_ALLOWED = "Predicate should not be null!";
    protected static final String NULL_AGGREGATOR_IS_NOT_ALLOWED = "Aggregator should not be null!";
    protected static final String NULL_PROJECTION_IS_NOT_ALLOWED = "Projection should not be null!";
    private static final ClientMessageDecoder GET_ASYNC_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)MapGetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder PUT_ASYNC_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)MapPutCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder SET_ASYNC_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return null;
        }
    };
    private static final ClientMessageDecoder REMOVE_ASYNC_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)MapRemoveCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder SUBMIT_TO_KEY_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)MapSubmitToKeyCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private ClientMessageDecoder eventJournalReadResponseDecoder;
    private ClientMessageDecoder eventJournalSubscribeResponseDecoder;
    private ClientLockReferenceIdGenerator lockReferenceIdGenerator;
    private ClientQueryCacheContext queryCacheContext;

    public ClientMapProxy(String serviceName, String name, ClientContext context) {
        super(serviceName, name, context);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.lockReferenceIdGenerator = this.getClient().getLockReferenceIdGenerator();
        this.queryCacheContext = this.getContext().getQueryCacheContext();
        this.eventJournalReadResponseDecoder = new ClientMessageDecoder(){

            public ReadResultSet<?> decodeClientMessage(ClientMessage message) {
                MapEventJournalReadCodec.ResponseParameters params = MapEventJournalReadCodec.decodeResponse((ClientMessage)message);
                PortableReadResultSet resultSet = new PortableReadResultSet(params.readCount, params.items, params.itemSeqs);
                resultSet.setSerializationService(ClientMapProxy.this.getSerializationService());
                return resultSet;
            }
        };
        this.eventJournalSubscribeResponseDecoder = new ClientMessageDecoder(){

            public EventJournalInitialSubscriberState decodeClientMessage(ClientMessage message) {
                MapEventJournalSubscribeCodec.ResponseParameters resp = MapEventJournalSubscribeCodec.decodeResponse((ClientMessage)message);
                return new EventJournalInitialSubscriberState(resp.oldestSequence, resp.newestSequence);
            }
        };
    }

    public boolean containsKey(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        return this.containsKeyInternal(key);
    }

    protected boolean containsKeyInternal(Object key) {
        Data keyData = this.toData(key);
        ClientMessage message = MapContainsKeyCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage result = (ClientMessage)this.invoke(message, keyData);
        MapContainsKeyCodec.ResponseParameters resultParameters = MapContainsKeyCodec.decodeResponse((ClientMessage)result);
        return resultParameters.response;
    }

    public boolean containsValue(Object value) {
        Preconditions.checkNotNull((Object)value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data valueData = this.toData(value);
        ClientMessage request = MapContainsValueCodec.encodeRequest((String)this.name, (Data)valueData);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapContainsValueCodec.ResponseParameters resultParameters = MapContainsValueCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public V get(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        return (V)this.toObject(this.getInternal(key));
    }

    protected Object getInternal(Object key) {
        Data keyData = this.toData(key);
        ClientMessage request = MapGetCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapGetCodec.ResponseParameters resultParameters = MapGetCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public V put(K key, V value) {
        return this.put(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public V remove(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        MapRemoveCodec.ResponseParameters resultParameters = this.removeInternal(key);
        return (V)this.toObject(resultParameters.response);
    }

    protected MapRemoveCodec.ResponseParameters removeInternal(Object key) {
        Data keyData = this.toData(key);
        ClientMessage request = MapRemoveCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        return MapRemoveCodec.decodeResponse((ClientMessage)response);
    }

    public boolean remove(Object key, Object value) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull((Object)value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        return this.removeInternal(key, value);
    }

    protected boolean removeInternal(Object key, Object value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        ClientMessage request = MapRemoveIfSameCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapRemoveIfSameCodec.ResponseParameters resultParameters = MapRemoveIfSameCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void removeAll(Predicate<K, V> predicate) {
        Preconditions.checkNotNull(predicate, (String)"predicate cannot be null");
        this.removeAllInternal(predicate);
    }

    protected void removeAllInternal(Predicate predicate) {
        ClientMessage request = MapRemoveAllCodec.encodeRequest((String)this.name, (Data)this.toData(predicate));
        this.invoke(request);
    }

    public void delete(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        this.deleteInternal(key);
    }

    protected void deleteInternal(Object key) {
        Data keyData = this.toData(key);
        ClientMessage request = MapDeleteCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        this.invoke(request, keyData);
    }

    public void flush() {
        ClientMessage request = MapFlushCodec.encodeRequest((String)this.name);
        this.invoke(request);
    }

    public ICompletableFuture<V> getAsync(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        return this.getAsyncInternal(key);
    }

    protected ICompletableFuture<V> getAsyncInternal(Object key) {
        try {
            Data keyData = this.toData(key);
            ClientMessage request = MapGetCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            return new ClientDelegatingFuture(future, this.getSerializationService(), GET_ASYNC_RESPONSE_DECODER);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private ClientInvocationFuture invokeOnKeyOwner(ClientMessage request, Data keyData) {
        int partitionId = this.getContext().getPartitionService().getPartitionId(keyData);
        ClientInvocation clientInvocation = new ClientInvocation(this.getClient(), request, this.getName(), partitionId);
        return clientInvocation.invoke();
    }

    public ICompletableFuture<V> putAsync(K key, V value) {
        return this.putAsync(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public ICompletableFuture<V> putAsync(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        return this.putAsyncInternal(ttl, timeunit, key, value);
    }

    protected ICompletableFuture<V> putAsyncInternal(long ttl, TimeUnit timeunit, Object key, Object value) {
        try {
            Data keyData = this.toData(key);
            Data valueData = this.toData(value);
            long ttlMillis = this.getTimeInMillis(ttl, timeunit);
            ClientMessage request = MapPutCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)ttlMillis);
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            return new ClientDelegatingFuture(future, this.getSerializationService(), PUT_ASYNC_RESPONSE_DECODER);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public ICompletableFuture<Void> setAsync(K key, V value) {
        return this.setAsync(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public ICompletableFuture<Void> setAsync(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        return this.setAsyncInternal(ttl, timeunit, key, value);
    }

    protected ICompletableFuture<Void> setAsyncInternal(long ttl, TimeUnit timeunit, Object key, Object value) {
        try {
            Data keyData = this.toData(key);
            Data valueData = this.toData(value);
            long ttlMillis = this.getTimeInMillis(ttl, timeunit);
            ClientMessage request = MapSetCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)ttlMillis);
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            return new ClientDelegatingFuture(future, this.getSerializationService(), SET_ASYNC_RESPONSE_DECODER);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public ICompletableFuture<V> removeAsync(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        return this.removeAsyncInternal(key);
    }

    protected ICompletableFuture<V> removeAsyncInternal(Object key) {
        try {
            Data keyData = this.toData(key);
            ClientMessage request = MapRemoveCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            return new ClientDelegatingFuture(future, this.getSerializationService(), REMOVE_ASYNC_RESPONSE_DECODER);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public boolean tryRemove(K key, long timeout, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        return this.tryRemoveInternal(timeout, timeunit, key);
    }

    protected boolean tryRemoveInternal(long timeout, TimeUnit timeunit, Object key) {
        Data keyData = this.toData(key);
        ClientMessage request = MapTryRemoveCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId(), (long)timeunit.toMillis(timeout));
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapTryRemoveCodec.ResponseParameters resultParameters = MapTryRemoveCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean tryPut(K key, V value, long timeout, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        return this.tryPutInternal(timeout, timeunit, key, value);
    }

    protected boolean tryPutInternal(long timeout, TimeUnit timeunit, Object key, Object value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        long timeoutMillis = this.getTimeInMillis(timeout, timeunit);
        ClientMessage request = MapTryPutCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)timeoutMillis);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapTryPutCodec.ResponseParameters resultParameters = MapTryPutCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public V put(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        return this.putInternal(ttl, timeunit, key, value);
    }

    protected V putInternal(long ttl, TimeUnit timeunit, Object key, Object value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        long ttlMillis = this.getTimeInMillis(ttl, timeunit);
        ClientMessage request = MapPutCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)ttlMillis);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapPutCodec.ResponseParameters resultParameters = MapPutCodec.decodeResponse((ClientMessage)response);
        return (V)this.toObject(resultParameters.response);
    }

    public void putTransient(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        this.putTransientInternal(ttl, timeunit, key, value);
    }

    protected void putTransientInternal(long ttl, TimeUnit timeunit, Object key, Object value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        long ttlMillis = this.getTimeInMillis(ttl, timeunit);
        ClientMessage request = MapPutTransientCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)ttlMillis);
        this.invoke(request, keyData);
    }

    public V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public V putIfAbsent(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        return this.putIfAbsentInternal(ttl, timeunit, key, value);
    }

    protected V putIfAbsentInternal(long ttl, TimeUnit timeunit, Object key, Object value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        long ttlMillis = this.getTimeInMillis(ttl, timeunit);
        ClientMessage request = MapPutIfAbsentCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)ttlMillis);
        ClientMessage result = (ClientMessage)this.invoke(request, keyData);
        MapPutIfAbsentCodec.ResponseParameters resultParameters = MapPutIfAbsentCodec.decodeResponse((ClientMessage)result);
        return (V)this.toObject(resultParameters.response);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(oldValue, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(newValue, (String)NULL_VALUE_IS_NOT_ALLOWED);
        return this.replaceIfSameInternal(key, oldValue, newValue);
    }

    protected boolean replaceIfSameInternal(Object key, Object oldValue, Object newValue) {
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        Data newValueData = this.toData(newValue);
        ClientMessage request = MapReplaceIfSameCodec.encodeRequest((String)this.name, (Data)keyData, (Data)oldValueData, (Data)newValueData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapReplaceIfSameCodec.ResponseParameters resultParameters = MapReplaceIfSameCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public V replace(K key, V value) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        return this.replaceInternal(key, value);
    }

    protected V replaceInternal(Object key, Object value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        ClientMessage request = MapReplaceCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapReplaceCodec.ResponseParameters resultParameters = MapReplaceCodec.decodeResponse((ClientMessage)response);
        return (V)this.toObject(resultParameters.response);
    }

    public void set(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        this.setInternal(ttl, timeunit, key, value);
    }

    protected void setInternal(long ttl, TimeUnit timeunit, Object key, Object value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        long ttlMillis = this.getTimeInMillis(ttl, timeunit);
        ClientMessage request = MapSetCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)ttlMillis);
        this.invoke(request, keyData);
    }

    public void lock(K key) {
        this.lock(key, -1L, TimeUnit.MILLISECONDS);
    }

    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapLockCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(leaseTime, timeUnit), (long)this.lockReferenceIdGenerator.getNextReferenceId());
        this.invoke(request, keyData);
    }

    public boolean isLocked(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapIsLockedCodec.encodeRequest((String)this.name, (Data)keyData);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapIsLockedCodec.ResponseParameters resultParameters = MapIsLockedCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean tryLock(K key) {
        try {
            return this.tryLock(key, 0L, null);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        return this.tryLock(key, time, timeunit, Long.MAX_VALUE, null);
    }

    public boolean tryLock(K key, long time, TimeUnit timeunit, long leaseTime, TimeUnit leaseUnit) throws InterruptedException {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        long leaseTimeMillis = this.getTimeInMillis(leaseTime, leaseUnit);
        long timeoutMillis = this.getTimeInMillis(time, timeunit);
        ClientMessage request = MapTryLockCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId(), (long)leaseTimeMillis, (long)timeoutMillis, (long)this.lockReferenceIdGenerator.getNextReferenceId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapTryLockCodec.ResponseParameters resultParameters = MapTryLockCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void unlock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapUnlockCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId(), (long)this.lockReferenceIdGenerator.getNextReferenceId());
        this.invoke(request, keyData);
    }

    public void forceUnlock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapForceUnlockCodec.encodeRequest((String)this.name, (Data)keyData, (long)this.lockReferenceIdGenerator.getNextReferenceId());
        this.invoke(request, keyData);
    }

    public String addLocalEntryListener(MapListener listener) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    public String addLocalEntryListener(EntryListener listener) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    public String addLocalEntryListener(MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    public String addLocalEntryListener(EntryListener listener, Predicate<K, V> predicate, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    public String addLocalEntryListener(MapListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    public String addLocalEntryListener(EntryListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    public String addInterceptor(MapInterceptor interceptor) {
        Data data = this.toData(interceptor);
        ClientMessage request = MapAddInterceptorCodec.encodeRequest((String)this.name, (Data)data);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapAddInterceptorCodec.ResponseParameters resultParameters = MapAddInterceptorCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void removeInterceptor(String id) {
        ClientMessage request = MapRemoveInterceptorCodec.encodeRequest((String)this.name, (String)id);
        this.invoke(request);
    }

    public String addEntryListener(MapListener listener, boolean includeValue) {
        Preconditions.checkNotNull((Object)listener, (String)NULL_LISTENER_IS_NOT_ALLOWED);
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter((Object)listener);
        return this.addEntryListenerInternal((ListenerAdapter<IMapEvent>)listenerAdaptor, includeValue);
    }

    public String addEntryListener(EntryListener listener, boolean includeValue) {
        Preconditions.checkNotNull((Object)listener, (String)NULL_LISTENER_IS_NOT_ALLOWED);
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter((Object)listener);
        return this.addEntryListenerInternal((ListenerAdapter<IMapEvent>)listenerAdaptor, includeValue);
    }

    private String addEntryListenerInternal(ListenerAdapter<IMapEvent> listenerAdaptor, boolean includeValue) {
        int listenerFlags = MapListenerFlagOperator.setAndGetListenerFlags(listenerAdaptor);
        EventHandler<ClientMessage> handler = this.createHandler(listenerAdaptor);
        return this.registerListener(this.createMapEntryListenerCodec(includeValue, listenerFlags), handler);
    }

    private ListenerMessageCodec createMapEntryListenerCodec(final boolean includeValue, final int listenerFlags) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddEntryListenerCodec.encodeRequest((String)ClientMapProxy.this.name, (boolean)includeValue, (int)listenerFlags, (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return MapAddEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest((String)ClientMapProxy.this.name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    public boolean removeEntryListener(String registrationId) {
        return this.deregisterListener(registrationId);
    }

    public String addPartitionLostListener(MapPartitionLostListener listener) {
        Preconditions.checkNotNull((Object)listener, (String)NULL_LISTENER_IS_NOT_ALLOWED);
        ClientMapPartitionLostEventHandler handler = new ClientMapPartitionLostEventHandler(listener);
        return this.registerListener(this.createMapPartitionListenerCodec(), handler);
    }

    private ListenerMessageCodec createMapPartitionListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddPartitionLostListenerCodec.encodeRequest((String)ClientMapProxy.this.name, (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return MapAddPartitionLostListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MapRemovePartitionLostListenerCodec.encodeRequest((String)ClientMapProxy.this.name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemovePartitionLostListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    public boolean removePartitionLostListener(String registrationId) {
        return this.deregisterListener(registrationId);
    }

    public String addEntryListener(MapListener listener, K key, boolean includeValue) {
        Preconditions.checkNotNull((Object)listener, (String)NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter((Object)listener);
        return this.addEntryListenerInternal((ListenerAdapter<IMapEvent>)listenerAdaptor, key, includeValue);
    }

    public String addEntryListener(EntryListener listener, K key, boolean includeValue) {
        Preconditions.checkNotNull((Object)listener, (String)NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter((Object)listener);
        return this.addEntryListenerInternal((ListenerAdapter<IMapEvent>)listenerAdaptor, key, includeValue);
    }

    private String addEntryListenerInternal(ListenerAdapter<IMapEvent> listenerAdaptor, K key, boolean includeValue) {
        int listenerFlags = MapListenerFlagOperator.setAndGetListenerFlags(listenerAdaptor);
        Data keyData = this.toData(key);
        EventHandler<ClientMessage> handler = this.createHandler(listenerAdaptor);
        return this.registerListener(this.createMapEntryListenerToKeyCodec(includeValue, listenerFlags, keyData), handler);
    }

    private ListenerMessageCodec createMapEntryListenerToKeyCodec(final boolean includeValue, final int listenerFlags, final Data keyData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddEntryListenerToKeyCodec.encodeRequest((String)ClientMapProxy.this.name, (Data)keyData, (boolean)includeValue, (int)listenerFlags, (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return MapAddEntryListenerToKeyCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest((String)ClientMapProxy.this.name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    public String addEntryListener(MapListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Preconditions.checkNotNull((Object)listener, (String)NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter((Object)listener);
        return this.addEntryListenerInternal((ListenerAdapter<IMapEvent>)listenerAdaptor, predicate, key, includeValue);
    }

    public String addEntryListener(EntryListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Preconditions.checkNotNull((Object)listener, (String)NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter((Object)listener);
        return this.addEntryListenerInternal((ListenerAdapter<IMapEvent>)listenerAdaptor, predicate, key, includeValue);
    }

    private String addEntryListenerInternal(ListenerAdapter<IMapEvent> listenerAdaptor, Predicate<K, V> predicate, K key, boolean includeValue) {
        int listenerFlags = MapListenerFlagOperator.setAndGetListenerFlags(listenerAdaptor);
        Data keyData = this.toData(key);
        Data predicateData = this.toData(predicate);
        EventHandler<ClientMessage> handler = this.createHandler(listenerAdaptor);
        ListenerMessageCodec codec = this.createEntryListenerToKeyWithPredicateCodec(includeValue, listenerFlags, keyData, predicateData);
        return this.registerListener(codec, handler);
    }

    private ListenerMessageCodec createEntryListenerToKeyWithPredicateCodec(final boolean includeValue, final int listenerFlags, final Data keyData, final Data predicateData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddEntryListenerToKeyWithPredicateCodec.encodeRequest((String)ClientMapProxy.this.name, (Data)keyData, (Data)predicateData, (boolean)includeValue, (int)listenerFlags, (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return MapAddEntryListenerToKeyWithPredicateCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest((String)ClientMapProxy.this.name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    public String addEntryListener(MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull((Object)listener, (String)NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, (String)NULL_PREDICATE_IS_NOT_ALLOWED);
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter((Object)listener);
        return this.addEntryListenerInternal((ListenerAdapter<IMapEvent>)listenerAdaptor, predicate, includeValue);
    }

    public String addEntryListener(EntryListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull((Object)listener, (String)NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, (String)NULL_PREDICATE_IS_NOT_ALLOWED);
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter((Object)listener);
        return this.addEntryListenerInternal((ListenerAdapter<IMapEvent>)listenerAdaptor, predicate, includeValue);
    }

    private String addEntryListenerInternal(ListenerAdapter<IMapEvent> listenerAdaptor, Predicate<K, V> predicate, boolean includeValue) {
        int listenerFlags = MapListenerFlagOperator.setAndGetListenerFlags(listenerAdaptor);
        Data predicateData = this.toData(predicate);
        EventHandler<ClientMessage> handler = this.createHandler(listenerAdaptor);
        return this.registerListener(this.createEntryListenerWithPredicateCodec(includeValue, listenerFlags, predicateData), handler);
    }

    private ListenerMessageCodec createEntryListenerWithPredicateCodec(final boolean includeValue, final int listenerFlags, final Data predicateData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddEntryListenerWithPredicateCodec.encodeRequest((String)ClientMapProxy.this.name, (Data)predicateData, (boolean)includeValue, (int)listenerFlags, (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return MapAddEntryListenerWithPredicateCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest((String)ClientMapProxy.this.name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    public EntryView<K, V> getEntryView(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapGetEntryViewCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapGetEntryViewCodec.ResponseParameters parameters = MapGetEntryViewCodec.decodeResponse((ClientMessage)response);
        SimpleEntryView dataEntryView = parameters.response;
        if (dataEntryView == null) {
            return null;
        }
        return new SimpleEntryView().withKey(this.toObject(dataEntryView.getKey())).withValue(this.toObject(dataEntryView.getValue())).withCost(dataEntryView.getCost()).withCreationTime(dataEntryView.getCreationTime()).withExpirationTime(dataEntryView.getExpirationTime()).withHits(dataEntryView.getHits()).withLastAccessTime(dataEntryView.getLastAccessTime()).withLastStoredTime(dataEntryView.getLastStoredTime()).withLastUpdateTime(dataEntryView.getLastUpdateTime()).withVersion(dataEntryView.getVersion()).withHits(dataEntryView.getHits()).withTtl(dataEntryView.getTtl());
    }

    public boolean evict(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        return this.evictInternal(key);
    }

    protected boolean evictInternal(Object key) {
        Data keyData = this.toData(key);
        ClientMessage request = MapEvictCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapEvictCodec.ResponseParameters resultParameters = MapEvictCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void evictAll() {
        ClientMessage request = MapEvictAllCodec.encodeRequest((String)this.name);
        this.invoke(request);
    }

    public void loadAll(boolean replaceExistingValues) {
        ClientMessage request = MapLoadAllCodec.encodeRequest((String)this.name, (boolean)replaceExistingValues);
        this.invoke(request);
    }

    public void loadAll(Set<K> keys, boolean replaceExistingValues) {
        Preconditions.checkNotNull(keys, (String)"Parameter keys should not be null.");
        if (keys.isEmpty()) {
            return;
        }
        this.loadAllInternal(replaceExistingValues, keys);
    }

    protected void loadAllInternal(boolean replaceExistingValues, Collection<?> keys) {
        Collection dataKeys = CollectionUtil.objectToDataCollection(keys, (SerializationService)this.getSerializationService());
        ClientMessage request = MapLoadGivenKeysCodec.encodeRequest((String)this.name, (Collection)dataKeys, (boolean)replaceExistingValues);
        this.invoke(request);
    }

    public Set<K> keySet() {
        ClientMessage request = MapKeySetCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapKeySetCodec.ResponseParameters resultParameters = MapKeySetCodec.decodeResponse((ClientMessage)response);
        InflatableSet.Builder setBuilder = InflatableSet.newBuilder((int)resultParameters.response.size());
        for (Data data : resultParameters.response) {
            Object key = this.toObject(data);
            setBuilder.add(key);
        }
        return setBuilder.build();
    }

    public Map<K, V> getAll(Set<K> keys) {
        if (CollectionUtil.isEmpty(keys)) {
            return Collections.emptyMap();
        }
        int keysSize = keys.size();
        HashMap<Integer, List<Data>> partitionToKeyData = new HashMap<Integer, List<Data>>();
        ArrayList<Object> resultingKeyValuePairs = new ArrayList<Object>(keysSize * 2);
        this.getAllInternal(keys, partitionToKeyData, resultingKeyValuePairs);
        Map result = MapUtil.createHashMap((int)keysSize);
        int i = 0;
        while (i < resultingKeyValuePairs.size()) {
            Object key = this.toObject(resultingKeyValuePairs.get(i++));
            Object value = this.toObject(resultingKeyValuePairs.get(i++));
            result.put(key, value);
        }
        return result;
    }

    protected void getAllInternal(Set<K> keys, Map<Integer, List<Data>> partitionToKeyData, List<Object> resultingKeyValuePairs) {
        if (partitionToKeyData.isEmpty()) {
            this.fillPartitionToKeyData(keys, partitionToKeyData, null, null);
        }
        ArrayList<ClientInvocationFuture> futures = new ArrayList<ClientInvocationFuture>(partitionToKeyData.size());
        for (Map.Entry<Integer, List<Data>> entry : partitionToKeyData.entrySet()) {
            int partitionId = entry.getKey();
            List<Data> keyList = entry.getValue();
            if (keyList.isEmpty()) continue;
            ClientMessage request = MapGetAllCodec.encodeRequest((String)this.name, keyList);
            futures.add(new ClientInvocation(this.getClient(), request, this.getName(), partitionId).invoke());
        }
        for (Future future : futures) {
            try {
                ClientMessage response = (ClientMessage)future.get();
                MapGetAllCodec.ResponseParameters resultParameters = MapGetAllCodec.decodeResponse((ClientMessage)response);
                for (Map.Entry entry : resultParameters.response) {
                    resultingKeyValuePairs.add(entry.getKey());
                    resultingKeyValuePairs.add(entry.getValue());
                }
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
    }

    protected void fillPartitionToKeyData(Set<K> keys, Map<Integer, List<Data>> partitionToKeyData, Map<Object, Data> keyMap, Map<Data, Object> reverseKeyMap) {
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        for (K key : keys) {
            Data keyData = this.toData(key);
            int partitionId = partitionService.getPartitionId(keyData);
            List<Data> keyList = partitionToKeyData.get(partitionId);
            if (keyList == null) {
                keyList = new ArrayList<Data>();
                partitionToKeyData.put(partitionId, keyList);
            }
            keyList.add(keyData);
            if (keyMap != null) {
                keyMap.put(key, keyData);
            }
            if (reverseKeyMap == null) continue;
            reverseKeyMap.put(keyData, key);
        }
    }

    public Collection<V> values() {
        ClientMessage request = MapValuesCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapValuesCodec.ResponseParameters resultParameters = MapValuesCodec.decodeResponse((ClientMessage)response);
        return new UnmodifiableLazyList(resultParameters.response, this.getSerializationService());
    }

    public Set<Map.Entry<K, V>> entrySet() {
        ClientMessage request = MapEntrySetCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapEntrySetCodec.ResponseParameters resultParameters = MapEntrySetCodec.decodeResponse((ClientMessage)response);
        InflatableSet.Builder setBuilder = InflatableSet.newBuilder((int)resultParameters.response.size());
        InternalSerializationService serializationService = (InternalSerializationService)this.getContext().getSerializationService();
        for (Map.Entry row : resultParameters.response) {
            LazyMapEntry entry = new LazyMapEntry((Data)row.getKey(), row.getValue(), serializationService);
            setBuilder.add((Object)entry);
        }
        return setBuilder.build();
    }

    public Set<K> keySet(Predicate predicate) {
        Preconditions.checkNotNull((Object)predicate, (String)NULL_PREDICATE_IS_NOT_ALLOWED);
        if (predicate instanceof PagingPredicate) {
            return this.keySetWithPagingPredicate((PagingPredicate)predicate);
        }
        ClientMessage request = MapKeySetWithPredicateCodec.encodeRequest((String)this.name, (Data)this.toData(predicate));
        ClientMessage response = this.invokeWithPredicate(request, predicate);
        MapKeySetWithPredicateCodec.ResponseParameters resultParameters = MapKeySetWithPredicateCodec.decodeResponse((ClientMessage)response);
        InflatableSet.Builder setBuilder = InflatableSet.newBuilder((int)resultParameters.response.size());
        for (Data data : resultParameters.response) {
            Object key = this.toObject(data);
            setBuilder.add(key);
        }
        return setBuilder.build();
    }

    private Set<K> keySetWithPagingPredicate(PagingPredicate pagingPredicate) {
        pagingPredicate.setIterationType(IterationType.KEY);
        ClientMessage request = MapKeySetWithPagingPredicateCodec.encodeRequest((String)this.name, (Data)this.toData(pagingPredicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapKeySetWithPagingPredicateCodec.ResponseParameters resultParameters = MapKeySetWithPagingPredicateCodec.decodeResponse((ClientMessage)response);
        ArrayList resultList = new ArrayList();
        for (Data keyData : resultParameters.response) {
            Object key = this.toObject(keyData);
            resultList.add(new AbstractMap.SimpleImmutableEntry(key, null));
        }
        return SortingUtil.getSortedQueryResultSet(resultList, (PagingPredicate)pagingPredicate, (IterationType)IterationType.KEY);
    }

    public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
        if (predicate instanceof PagingPredicate) {
            return this.entrySetWithPagingPredicate((PagingPredicate)predicate);
        }
        ClientMessage request = MapEntriesWithPredicateCodec.encodeRequest((String)this.name, (Data)this.toData(predicate));
        ClientMessage response = this.invokeWithPredicate(request, predicate);
        MapEntriesWithPredicateCodec.ResponseParameters resultParameters = MapEntriesWithPredicateCodec.decodeResponse((ClientMessage)response);
        InflatableSet.Builder setBuilder = InflatableSet.newBuilder((int)resultParameters.response.size());
        InternalSerializationService serializationService = (InternalSerializationService)this.getContext().getSerializationService();
        for (Map.Entry row : resultParameters.response) {
            LazyMapEntry entry = new LazyMapEntry((Data)row.getKey(), row.getValue(), serializationService);
            setBuilder.add((Object)entry);
        }
        return setBuilder.build();
    }

    private Set<Map.Entry<K, V>> entrySetWithPagingPredicate(PagingPredicate pagingPredicate) {
        pagingPredicate.setIterationType(IterationType.ENTRY);
        ClientMessage request = MapEntriesWithPagingPredicateCodec.encodeRequest((String)this.name, (Data)this.toData(pagingPredicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapEntriesWithPagingPredicateCodec.ResponseParameters resultParameters = MapEntriesWithPagingPredicateCodec.decodeResponse((ClientMessage)response);
        ArrayList resultList = new ArrayList();
        for (Map.Entry entry : resultParameters.response) {
            Object key = this.toObject(entry.getKey());
            Object value = this.toObject(entry.getValue());
            resultList.add(new AbstractMap.SimpleEntry(key, value));
        }
        ResultSet result = SortingUtil.getSortedQueryResultSet(resultList, (PagingPredicate)pagingPredicate, (IterationType)IterationType.ENTRY);
        return result;
    }

    public Collection<V> values(Predicate predicate) {
        Preconditions.checkNotNull((Object)predicate, (String)NULL_PREDICATE_IS_NOT_ALLOWED);
        if (predicate instanceof PagingPredicate) {
            return this.valuesForPagingPredicate((PagingPredicate)predicate);
        }
        ClientMessage request = MapValuesWithPredicateCodec.encodeRequest((String)this.name, (Data)this.toData(predicate));
        ClientMessage response = this.invokeWithPredicate(request, predicate);
        MapValuesWithPredicateCodec.ResponseParameters resultParameters = MapValuesWithPredicateCodec.decodeResponse((ClientMessage)response);
        return new UnmodifiableLazyList(resultParameters.response, this.getSerializationService());
    }

    private ClientMessage invokeWithPredicate(ClientMessage request, Predicate predicate) {
        ClientMessage response;
        if (predicate instanceof PartitionPredicate) {
            PartitionPredicate partitionPredicate = (PartitionPredicate)predicate;
            response = (ClientMessage)this.invoke(request, partitionPredicate.getPartitionKey());
        } else {
            response = (ClientMessage)this.invoke(request);
        }
        return response;
    }

    private Collection<V> valuesForPagingPredicate(PagingPredicate pagingPredicate) {
        pagingPredicate.setIterationType(IterationType.VALUE);
        ClientMessage request = MapValuesWithPagingPredicateCodec.encodeRequest((String)this.name, (Data)this.toData(pagingPredicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapValuesWithPagingPredicateCodec.ResponseParameters resultParameters = MapValuesWithPagingPredicateCodec.decodeResponse((ClientMessage)response);
        ArrayList resultList = new ArrayList(resultParameters.response.size());
        for (Map.Entry entry : resultParameters.response) {
            Object key = this.toObject(entry.getKey());
            Object value = this.toObject(entry.getValue());
            resultList.add(new AbstractMap.SimpleImmutableEntry(key, value));
        }
        return SortingUtil.getSortedQueryResultSet(resultList, (PagingPredicate)pagingPredicate, (IterationType)IterationType.VALUE);
    }

    public Set<K> localKeySet() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    public Set<K> localKeySet(Predicate predicate) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    public void addIndex(String attribute, boolean ordered) {
        ClientMessage request = MapAddIndexCodec.encodeRequest((String)this.name, (String)attribute, (boolean)ordered);
        this.invoke(request);
    }

    public LocalMapStats getLocalMapStats() {
        return new LocalMapStatsImpl();
    }

    public Object executeOnKey(K key, EntryProcessor entryProcessor) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        return this.executeOnKeyInternal(key, entryProcessor);
    }

    public Object executeOnKeyInternal(Object key, EntryProcessor entryProcessor) {
        ClientMapProxy.validateEntryProcessorForSingleKeyProcessing(entryProcessor);
        Data keyData = this.toData(key);
        ClientMessage request = MapExecuteOnKeyCodec.encodeRequest((String)this.name, (Data)this.toData(entryProcessor), (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapExecuteOnKeyCodec.ResponseParameters resultParameters = MapExecuteOnKeyCodec.decodeResponse((ClientMessage)response);
        return this.toObject(resultParameters.response);
    }

    public void submitToKey(K key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        this.submitToKeyInternal(key, entryProcessor, callback);
    }

    public void submitToKeyInternal(Object key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        try {
            Data keyData = this.toData(key);
            ClientMessage request = MapSubmitToKeyCodec.encodeRequest((String)this.name, (Data)this.toData(entryProcessor), (Data)keyData, (long)ThreadUtil.getThreadId());
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            new ClientDelegatingFuture(future, this.getSerializationService(), SUBMIT_TO_KEY_RESPONSE_DECODER).andThen(callback);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public ICompletableFuture submitToKey(K key, EntryProcessor entryProcessor) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        return this.submitToKeyInternal(key, entryProcessor);
    }

    public ICompletableFuture submitToKeyInternal(Object key, EntryProcessor entryProcessor) {
        try {
            Data keyData = this.toData(key);
            ClientMessage request = MapSubmitToKeyCodec.encodeRequest((String)this.name, (Data)this.toData(entryProcessor), (Data)keyData, (long)ThreadUtil.getThreadId());
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            return new ClientDelegatingFuture(future, this.getSerializationService(), SUBMIT_TO_KEY_RESPONSE_DECODER);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor) {
        ClientMessage request = MapExecuteOnAllKeysCodec.encodeRequest((String)this.name, (Data)this.toData(entryProcessor));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapExecuteOnAllKeysCodec.ResponseParameters resultParameters = MapExecuteOnAllKeysCodec.decodeResponse((ClientMessage)response);
        return this.prepareResult(resultParameters.response);
    }

    protected Map<K, Object> prepareResult(Collection<Map.Entry<Data, Data>> entries) {
        if (CollectionUtil.isEmpty(entries)) {
            return Collections.emptyMap();
        }
        Map result = MapUtil.createHashMap((int)entries.size());
        for (Map.Entry<Data, Data> entry : entries) {
            Object key = this.toObject(entry.getKey());
            result.put(key, this.toObject(entry.getValue()));
        }
        return result;
    }

    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor, Predicate predicate) {
        ClientMessage request = MapExecuteWithPredicateCodec.encodeRequest((String)this.name, (Data)this.toData(entryProcessor), (Data)this.toData(predicate));
        ClientMessage response = this.invokeWithPredicate(request, predicate);
        MapExecuteWithPredicateCodec.ResponseParameters resultParameters = MapExecuteWithPredicateCodec.decodeResponse((ClientMessage)response);
        return this.prepareResult(resultParameters.response);
    }

    public <R> R aggregate(Aggregator<Map.Entry<K, V>, R> aggregator) {
        Preconditions.checkNotNull(aggregator, (String)NULL_AGGREGATOR_IS_NOT_ALLOWED);
        ClientMessage request = MapAggregateCodec.encodeRequest((String)this.name, (Data)this.toData(aggregator));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapAggregateCodec.ResponseParameters resultParameters = MapAggregateCodec.decodeResponse((ClientMessage)response);
        return (R)this.toObject(resultParameters.response);
    }

    public <R> R aggregate(Aggregator<Map.Entry<K, V>, R> aggregator, Predicate<K, V> predicate) {
        Preconditions.checkNotNull(aggregator, (String)NULL_AGGREGATOR_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, (String)NULL_PREDICATE_IS_NOT_ALLOWED);
        ClientMapProxy.checkNotPagingPredicate(predicate, "aggregate");
        ClientMessage request = MapAggregateWithPredicateCodec.encodeRequest((String)this.name, (Data)this.toData(aggregator), (Data)this.toData(predicate));
        ClientMessage response = this.invokeWithPredicate(request, predicate);
        MapAggregateWithPredicateCodec.ResponseParameters resultParameters = MapAggregateWithPredicateCodec.decodeResponse((ClientMessage)response);
        return (R)this.toObject(resultParameters.response);
    }

    public <R> Collection<R> project(Projection<Map.Entry<K, V>, R> projection) {
        ClientMessage request = MapProjectCodec.encodeRequest((String)this.name, (Data)this.toData(projection));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapProjectCodec.ResponseParameters resultParameters = MapProjectCodec.decodeResponse((ClientMessage)response);
        return new UnmodifiableLazyList(resultParameters.response, this.getSerializationService());
    }

    public <R> Collection<R> project(Projection<Map.Entry<K, V>, R> projection, Predicate<K, V> predicate) {
        ClientMapProxy.checkNotPagingPredicate(predicate, "project");
        ClientMessage request = MapProjectWithPredicateCodec.encodeRequest((String)this.name, (Data)this.toData(projection), (Data)this.toData(predicate));
        ClientMessage response = this.invokeWithPredicate(request, predicate);
        MapProjectWithPredicateCodec.ResponseParameters resultParameters = MapProjectWithPredicateCodec.decodeResponse((ClientMessage)response);
        return new UnmodifiableLazyList(resultParameters.response, this.getSerializationService());
    }

    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation) {
        JobTracker jobTracker = this.getClient().getJobTracker("hz::aggregation-map-" + this.name);
        return this.aggregate(supplier, aggregation, jobTracker);
    }

    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
        try {
            Preconditions.isNotNull((Object)jobTracker, (String)"jobTracker");
            KeyValueSource keyValueSource = KeyValueSource.fromMap((IMap)this);
            Job job = jobTracker.newJob(keyValueSource);
            Mapper mapper = aggregation.getMapper(supplier);
            CombinerFactory combinerFactory = aggregation.getCombinerFactory();
            ReducerFactory reducerFactory = aggregation.getReducerFactory();
            Collator collator = aggregation.getCollator();
            MappingJob mappingJob = job.mapper(mapper);
            ReducingSubmittableJob reducingJob = combinerFactory != null ? mappingJob.combiner(combinerFactory).reducer(reducerFactory) : mappingJob.reducer(reducerFactory);
            JobCompletableFuture future = reducingJob.submit(collator);
            return (Result)future.get();
        }
        catch (Exception e) {
            throw new HazelcastException((Throwable)e);
        }
    }

    public QueryCache<K, V> getQueryCache(String name) {
        Preconditions.checkNotNull((Object)name, (String)"name cannot be null");
        return this.getQueryCacheInternal(name, null, null, null, this);
    }

    public QueryCache<K, V> getQueryCache(String name, Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull((Object)name, (String)"name cannot be null");
        Preconditions.checkNotNull(predicate, (String)"predicate cannot be null");
        Preconditions.checkNotInstanceOf(PagingPredicate.class, predicate, (String)"predicate");
        return this.getQueryCacheInternal(name, null, predicate, includeValue, this);
    }

    public QueryCache<K, V> getQueryCache(String name, MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull((Object)name, (String)"name cannot be null");
        Preconditions.checkNotNull(predicate, (String)"predicate cannot be null");
        Preconditions.checkNotInstanceOf(PagingPredicate.class, predicate, (String)"predicate");
        return this.getQueryCacheInternal(name, listener, predicate, includeValue, this);
    }

    private QueryCache<K, V> getQueryCacheInternal(String name, MapListener listener, Predicate predicate, Boolean includeValue, IMap map) {
        QueryCacheRequest request = QueryCacheRequests.newQueryCacheRequest().withCacheName(name).withCacheId(UuidUtil.newUnsecureUuidString()).withListener(listener).withPredicate(predicate).withIncludeValue(includeValue).forMap(map).withContext((QueryCacheContext)this.queryCacheContext);
        return this.createQueryCache(request);
    }

    private QueryCache<K, V> createQueryCache(QueryCacheRequest request) {
        SubscriberContext subscriberContext = this.queryCacheContext.getSubscriberContext();
        QueryCacheEndToEndProvider queryCacheEndToEndProvider = subscriberContext.getEndToEndQueryCacheProvider();
        return queryCacheEndToEndProvider.getOrCreateQueryCache(request.getMapName(), request.getCacheId(), (ConstructorFunction)new ClientQueryCacheEndToEndConstructor(request));
    }

    public Map<K, Object> executeOnKeys(Set<K> keys, EntryProcessor entryProcessor) {
        Preconditions.checkNotNull(keys, (String)NULL_KEY_IS_NOT_ALLOWED);
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        Collection dataCollection = CollectionUtil.objectToDataCollection(keys, (SerializationService)this.getSerializationService());
        ClientMessage request = MapExecuteOnKeysCodec.encodeRequest((String)this.name, (Data)this.toData(entryProcessor), (Collection)dataCollection);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapExecuteOnKeysCodec.ResponseParameters resultParameters = MapExecuteOnKeysCodec.decodeResponse((ClientMessage)response);
        return this.prepareResult(resultParameters.response);
    }

    public void set(K key, V value) {
        this.set(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public int size() {
        ClientMessage request = MapSizeCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapSizeCodec.ResponseParameters resultParameters = MapSizeCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean isEmpty() {
        ClientMessage request = MapIsEmptyCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapIsEmptyCodec.ResponseParameters resultParameters = MapIsEmptyCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        int partitionCount = partitionService.getPartitionCount();
        HashMap<Integer, List<Map.Entry<Data, Data>>> entryMap = new HashMap<Integer, List<Map.Entry<Data, Data>>>(partitionCount);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Preconditions.checkNotNull(entry.getKey(), (String)NULL_KEY_IS_NOT_ALLOWED);
            Preconditions.checkNotNull(entry.getValue(), (String)NULL_VALUE_IS_NOT_ALLOWED);
            Data keyData = this.toData(entry.getKey());
            int partitionId = partitionService.getPartitionId(keyData);
            ArrayList<AbstractMap.SimpleEntry<Data, Data>> partition = (ArrayList<AbstractMap.SimpleEntry<Data, Data>>)entryMap.get(partitionId);
            if (partition == null) {
                partition = new ArrayList<AbstractMap.SimpleEntry<Data, Data>>();
                entryMap.put(partitionId, partition);
            }
            partition.add(new AbstractMap.SimpleEntry<Data, Data>(keyData, this.toData(entry.getValue())));
        }
        this.putAllInternal(map, entryMap);
    }

    protected void putAllInternal(Map<? extends K, ? extends V> map, Map<Integer, List<Map.Entry<Data, Data>>> entryMap) {
        ArrayList<ClientInvocationFuture> futures = new ArrayList<ClientInvocationFuture>(entryMap.size());
        for (Map.Entry<Integer, List<Map.Entry<Data, Data>>> entry : entryMap.entrySet()) {
            Integer partitionId = entry.getKey();
            ClientMessage request = MapPutAllCodec.encodeRequest((String)this.name, (Collection)entry.getValue());
            futures.add(new ClientInvocation(this.getClient(), request, this.getName(), partitionId).invoke());
        }
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public void clear() {
        ClientMessage request = MapClearCodec.encodeRequest((String)this.name);
        this.invoke(request);
    }

    public String toString() {
        return "IMap{name='" + this.name + '\'' + '}';
    }

    public Iterator<Map.Entry<K, V>> iterator(int fetchSize, int partitionId, boolean prefetchValues) {
        return new ClientMapPartitionIterator(this, this.getContext(), fetchSize, partitionId, prefetchValues);
    }

    public <R> Iterator<R> iterator(int fetchSize, int partitionId, Projection<Map.Entry<K, V>, R> projection, Predicate<K, V> predicate) {
        Preconditions.checkNotNull(projection, (String)NULL_PROJECTION_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, (String)NULL_PREDICATE_IS_NOT_ALLOWED);
        ClientMapProxy.checkNotPagingPredicate(predicate, "iterator");
        return new ClientMapQueryPartitionIterator<K, V, R>(this, this.getContext(), fetchSize, partitionId, predicate, projection);
    }

    public ICompletableFuture<EventJournalInitialSubscriberState> subscribeToEventJournal(int partitionId) {
        ClientMessage request = MapEventJournalSubscribeCodec.encodeRequest((String)this.name);
        ClientInvocationFuture fut = new ClientInvocation(this.getClient(), request, this.getName(), partitionId).invoke();
        return new ClientDelegatingFuture(fut, this.getSerializationService(), this.eventJournalSubscribeResponseDecoder);
    }

    public <T> ICompletableFuture<ReadResultSet<T>> readFromEventJournal(long startSequence, int minSize, int maxSize, int partitionId, com.hazelcast.util.function.Predicate<? super EventJournalMapEvent<K, V>> predicate, Projection<? super EventJournalMapEvent<K, V>, ? extends T> projection) {
        SerializationService ss = this.getSerializationService();
        ClientMessage request = MapEventJournalReadCodec.encodeRequest((String)this.name, (long)startSequence, (int)minSize, (int)maxSize, (Data)ss.toData(predicate), (Data)ss.toData(projection));
        ClientInvocationFuture fut = new ClientInvocation(this.getClient(), request, this.getName(), partitionId).invoke();
        return new ClientDelegatingFuture(fut, ss, this.eventJournalReadResponseDecoder);
    }

    public ClientQueryCacheContext getQueryCacheContext() {
        return this.queryCacheContext;
    }

    private long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    private EventHandler<ClientMessage> createHandler(ListenerAdapter<IMapEvent> listenerAdapter) {
        return new ClientMapEventHandler(listenerAdapter);
    }

    private static void validateEntryProcessorForSingleKeyProcessing(EntryProcessor entryProcessor) {
        EntryBackupProcessor backupProcessor;
        if (entryProcessor instanceof ReadOnly && (backupProcessor = entryProcessor.getBackupProcessor()) != null) {
            throw new IllegalArgumentException("EntryProcessor.getBackupProcessor() should be null for a read-only EntryProcessor");
        }
    }

    private static void checkNotPagingPredicate(Predicate predicate, String method) {
        if (predicate instanceof PagingPredicate) {
            throw new IllegalArgumentException("PagingPredicate not supported in " + method + " method");
        }
    }

    @Override
    protected void onDestroy() {
        try {
            SubscriberContext subscriberContext = this.queryCacheContext.getSubscriberContext();
            QueryCacheEndToEndProvider provider = subscriberContext.getEndToEndQueryCacheProvider();
            provider.destroyAllQueryCaches(this.name);
        }
        finally {
            super.onDestroy();
        }
    }

    private class ClientMapPartitionLostEventHandler
    extends MapAddPartitionLostListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private MapPartitionLostListener listener;

        ClientMapPartitionLostEventHandler(MapPartitionLostListener listener) {
            this.listener = listener;
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }

        public void handle(int partitionId, String uuid) {
            Member member = ClientMapProxy.this.getContext().getClusterService().getMember(uuid);
            this.listener.partitionLost(new MapPartitionLostEvent((Object)ClientMapProxy.this.name, member, -1, partitionId));
        }
    }

    private class ClientMapEventHandler
    extends MapAddEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private ListenerAdapter<IMapEvent> listenerAdapter;

        ClientMapEventHandler(ListenerAdapter<IMapEvent> listenerAdapter) {
            this.listenerAdapter = listenerAdapter;
        }

        public void handle(Data key, Data value, Data oldValue, Data mergingValue, int eventType, String uuid, int numberOfAffectedEntries) {
            Member member = ClientMapProxy.this.getContext().getClusterService().getMember(uuid);
            this.listenerAdapter.onEvent((Object)this.createIMapEvent(key, value, oldValue, mergingValue, eventType, numberOfAffectedEntries, member));
        }

        private IMapEvent createIMapEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, int numberOfAffectedEntries, Member member) {
            EntryEventType entryEventType = EntryEventType.getByType((int)eventType);
            Preconditions.checkNotNull((Object)entryEventType, (String)("Unknown eventType: " + eventType));
            switch (entryEventType) {
                case ADDED: 
                case REMOVED: 
                case UPDATED: 
                case EVICTED: 
                case EXPIRED: 
                case MERGED: {
                    return this.createEntryEvent(key, value, oldValue, mergingValue, eventType, member);
                }
                case EVICT_ALL: 
                case CLEAR_ALL: {
                    return this.createMapEvent(eventType, numberOfAffectedEntries, member);
                }
            }
            throw new IllegalArgumentException("Not a known event type: " + entryEventType);
        }

        private MapEvent createMapEvent(int eventType, int numberOfAffectedEntries, Member member) {
            return new MapEvent((Object)ClientMapProxy.this.name, member, eventType, numberOfAffectedEntries);
        }

        private EntryEvent<K, V> createEntryEvent(Data keyData, Data valueData, Data oldValueData, Data mergingValueData, int eventType, Member member) {
            return new DataAwareEntryEvent(member, eventType, ClientMapProxy.this.name, keyData, valueData, oldValueData, mergingValueData, ClientMapProxy.this.getSerializationService());
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

