/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientNearCacheConfigTest {
    @Test
    public void testSpecificNearCacheConfig_whenAsteriskAtTheEnd() {
        ClientConfig clientConfig = new ClientConfig();
        NearCacheConfig genericNearCacheConfig = new NearCacheConfig();
        genericNearCacheConfig.setName("map*");
        clientConfig.addNearCacheConfig(genericNearCacheConfig);
        NearCacheConfig specificNearCacheConfig = new NearCacheConfig();
        specificNearCacheConfig.setName("mapStudent*");
        clientConfig.addNearCacheConfig(specificNearCacheConfig);
        NearCacheConfig mapFoo = clientConfig.getNearCacheConfig("mapFoo");
        NearCacheConfig mapStudentFoo = clientConfig.getNearCacheConfig("mapStudentFoo");
        Assert.assertEquals((Object)genericNearCacheConfig, (Object)mapFoo);
        Assert.assertEquals((Object)specificNearCacheConfig, (Object)mapStudentFoo);
    }

    @Test
    public void testSpecificNearCacheConfig_whenAsteriskAtTheBeginning() {
        ClientConfig clientConfig = new ClientConfig();
        NearCacheConfig genericNearCacheConfig = new NearCacheConfig();
        genericNearCacheConfig.setName("*Map");
        clientConfig.addNearCacheConfig(genericNearCacheConfig);
        NearCacheConfig specificNearCacheConfig = new NearCacheConfig();
        specificNearCacheConfig.setName("*MapStudent");
        clientConfig.addNearCacheConfig(specificNearCacheConfig);
        NearCacheConfig mapFoo = clientConfig.getNearCacheConfig("fooMap");
        NearCacheConfig mapStudentFoo = clientConfig.getNearCacheConfig("fooMapStudent");
        Assert.assertEquals((Object)genericNearCacheConfig, (Object)mapFoo);
        Assert.assertEquals((Object)specificNearCacheConfig, (Object)mapStudentFoo);
    }

    @Test
    public void testSpecificNearCacheConfig_whenAsteriskInTheMiddle() {
        ClientConfig clientConfig = new ClientConfig();
        NearCacheConfig genericNearCacheConfig = new NearCacheConfig();
        genericNearCacheConfig.setName("map*Bar");
        clientConfig.addNearCacheConfig(genericNearCacheConfig);
        NearCacheConfig specificNearCacheConfig = new NearCacheConfig();
        specificNearCacheConfig.setName("mapStudent*Bar");
        clientConfig.addNearCacheConfig(specificNearCacheConfig);
        NearCacheConfig mapFoo = clientConfig.getNearCacheConfig("mapFooBar");
        NearCacheConfig mapStudentFoo = clientConfig.getNearCacheConfig("mapStudentFooBar");
        Assert.assertEquals((Object)genericNearCacheConfig, (Object)mapFoo);
        Assert.assertEquals((Object)specificNearCacheConfig, (Object)mapStudentFoo);
    }
}

