/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.client.cache.impl.ClientCacheHelper;
import com.hazelcast.client.impl.ClientTestUtil;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.Member;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheHelperTest
extends HazelcastTestSupport {
    private static final String CACHE_NAME = "fullCacheName";
    private static final String SIMPLE_CACHE_NAME = "cacheName";
    private TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastClientInstanceImpl client;
    private HazelcastClientInstanceImpl exceptionThrowingClient;
    private CacheConfig<String, String> newCacheConfig;
    private CacheConfig<String, String> cacheConfig;
    private ConcurrentMap<String, CacheConfig> configs;

    @Before
    public void setUp() {
        CacheSimpleConfig cacheSimpleConfig = new CacheSimpleConfig();
        cacheSimpleConfig.setName(SIMPLE_CACHE_NAME);
        Config config = new Config();
        config.addCacheConfig(cacheSimpleConfig);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.client = ClientTestUtil.getHazelcastClientInstanceImpl(this.hazelcastFactory.newHazelcastClient());
        this.exceptionThrowingClient = (HazelcastClientInstanceImpl)Mockito.mock(HazelcastClientInstanceImpl.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.exceptionThrowingClient.getClientPartitionService()).thenThrow(new Throwable[]{new IllegalArgumentException("expected")});
        this.newCacheConfig = new CacheConfig(CACHE_NAME);
        this.cacheConfig = new CacheConfig(CACHE_NAME);
        this.configs = new ConcurrentHashMap<String, CacheConfig<String, String>>(Collections.singletonMap(CACHE_NAME, this.cacheConfig));
    }

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testConstructor() {
        ClientCacheHelperTest.assertUtilityConstructor(ClientCacheHelper.class);
    }

    @Test
    public void testGetCacheConfig() {
        CacheConfig cacheConfig = ClientCacheHelper.getCacheConfig((HazelcastClientInstanceImpl)this.client, (String)CACHE_NAME, (String)CACHE_NAME);
        Assert.assertNull((Object)cacheConfig);
    }

    @Test
    public void testGetCacheConfig_withSimpleCacheName() {
        CacheConfig cacheConfig = ClientCacheHelper.getCacheConfig((HazelcastClientInstanceImpl)this.client, (String)SIMPLE_CACHE_NAME, (String)SIMPLE_CACHE_NAME);
        Assert.assertNotNull((Object)cacheConfig);
        Assert.assertEquals((Object)SIMPLE_CACHE_NAME, (Object)cacheConfig.getName());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetCacheConfig_rethrowsExceptions() {
        ClientCacheHelper.getCacheConfig((HazelcastClientInstanceImpl)this.exceptionThrowingClient, (String)CACHE_NAME, (String)"simpleCacheName");
    }

    @Test
    public void testCreateCacheConfig_whenSyncCreate_thenReturnNewConfig() {
        CacheConfig actualConfig = ClientCacheHelper.createCacheConfig((HazelcastClientInstanceImpl)this.client, this.cacheConfig, this.newCacheConfig, (boolean)false, (boolean)true);
        Assert.assertNotEquals(this.cacheConfig, (Object)actualConfig);
    }

    @Test
    public void testCreateCacheConfig_whenNotSyncCreate_thenReturnCurrentConfig() {
        CacheConfig actualConfig = ClientCacheHelper.createCacheConfig((HazelcastClientInstanceImpl)this.client, this.cacheConfig, this.newCacheConfig, (boolean)false, (boolean)false);
        Assert.assertEquals(this.cacheConfig, (Object)actualConfig);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateCacheConfig_rethrowsExceptions() {
        ClientCacheHelper.createCacheConfig((HazelcastClientInstanceImpl)this.exceptionThrowingClient, this.cacheConfig, this.newCacheConfig, (boolean)false, (boolean)false);
    }

    @Test
    public void testEnableStatisticManagementOnNodes() {
        ClientCacheHelper.enableStatisticManagementOnNodes((HazelcastClientInstanceImpl)this.client, (String)CACHE_NAME, (boolean)false, (boolean)false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnableStatisticManagementOnNodes_sneakyThrowsException() {
        Member member = (Member)Mockito.mock(Member.class);
        Mockito.when((Object)member.getAddress()).thenThrow(new Throwable[]{new IllegalArgumentException("expected")});
        List<Member> members = Collections.singletonList(member);
        Mockito.when((Object)this.exceptionThrowingClient.getClientClusterService().getMemberList()).thenReturn(members);
        ClientCacheHelper.enableStatisticManagementOnNodes((HazelcastClientInstanceImpl)this.exceptionThrowingClient, (String)CACHE_NAME, (boolean)false, (boolean)false);
    }
}

