/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache.invalidation;

import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.cache.impl.NearCachedClientCacheProxy;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.impl.nearcache.invalidation.MemberMapReconciliationTest;
import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheReconciliationTest
extends HazelcastTestSupport {
    private static final String CACHE_NAME = "test";
    private static final int RECONCILIATION_INTERVAL_SECONDS = 3;
    private final TestHazelcastFactory factory = new TestHazelcastFactory();
    private final ClientConfig clientConfig = new ClientConfig();
    private final CacheConfig cacheConfig = new CacheConfig();
    private Cache serverCache;
    private Cache clientCache;

    @Before
    public void setUp() throws Exception {
        NearCacheConfig nearCacheConfig = new NearCacheConfig(CACHE_NAME);
        nearCacheConfig.setInvalidateOnChange(true);
        this.clientConfig.setProperty("hazelcast.invalidation.max.tolerated.miss.count", "0");
        this.clientConfig.setProperty("hazelcast.invalidation.reconciliation.interval.seconds", String.valueOf(3));
        this.clientConfig.setProperty("hazelcast.invalidation.min.reconciliation.interval.seconds", String.valueOf(3));
        this.clientConfig.addNearCacheConfig(nearCacheConfig);
        this.cacheConfig.getEvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(Integer.MAX_VALUE);
        Config config = new Config();
        config.setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getName(), String.valueOf(Integer.MAX_VALUE));
        config.setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_SIZE.getName(), String.valueOf(Integer.MAX_VALUE));
        HazelcastInstance server = this.factory.newHazelcastInstance(config);
        HazelcastServerCachingProvider provider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)server);
        CacheManager serverCacheManager = provider.getCacheManager();
        this.serverCache = serverCacheManager.createCache(CACHE_NAME, (Configuration)this.cacheConfig);
        this.clientCache = this.createCacheFromNewClient();
    }

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    private Cache createCacheFromNewClient() {
        HazelcastClientProxy client = (HazelcastClientProxy)this.factory.newHazelcastClient(this.clientConfig);
        HazelcastClientCachingProvider clientCachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        CacheManager cacheManager = clientCachingProvider.getCacheManager();
        Cache cache = cacheManager.createCache(CACHE_NAME, (Configuration)this.cacheConfig);
        assert (cache instanceof NearCachedClientCacheProxy);
        return cache;
    }

    @Test
    public void test_reconciliation_does_not_cause_premature_removal() throws Exception {
        int i;
        int total = 100;
        for (i = 0; i < total; ++i) {
            this.serverCache.put((Object)i, (Object)i);
        }
        for (i = 0; i < total; ++i) {
            this.clientCache.get((Object)i);
        }
        Cache cacheFromNewClient = this.createCacheFromNewClient();
        for (int i2 = 0; i2 < total; ++i2) {
            cacheFromNewClient.get((Object)i2);
        }
        NearCacheStats nearCacheStats = ((ICache)cacheFromNewClient).getLocalCacheStatistics().getNearCacheStatistics();
        MemberMapReconciliationTest.assertStats((NearCacheStats)nearCacheStats, (int)total, (int)0, (int)total);
        ClientCacheReconciliationTest.sleepSeconds((int)6);
        for (int i3 = 0; i3 < total; ++i3) {
            cacheFromNewClient.get((Object)i3);
        }
        MemberMapReconciliationTest.assertStats((NearCacheStats)nearCacheStats, (int)total, (int)total, (int)total);
    }
}

