/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache.invalidation;

import com.hazelcast.cache.impl.CacheEventHandler;
import com.hazelcast.cache.impl.CacheProxy;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.cache.impl.NearCachedClientCacheProxy;
import com.hazelcast.client.cache.impl.nearcache.ClientNearCacheTestSupport;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheRecord;
import com.hazelcast.internal.nearcache.NearCacheRecordStore;
import com.hazelcast.internal.nearcache.impl.DefaultNearCache;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataContainer;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataGenerator;
import com.hazelcast.internal.nearcache.impl.invalidation.StaleReadDetector;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.util.RandomPicker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={NightlyTest.class})
public class InvalidationMemberAddRemoveTest
extends ClientNearCacheTestSupport {
    private static final int NEAR_CACHE_POPULATOR_THREAD_COUNT = 5;
    private static final int TEST_RUN_SECONDS = 30;
    private static final int INVALIDATION_BATCH_SIZE = 100;
    private static final int KEY_COUNT = 1000;
    private static final int RECONCILIATION_INTERVAL_SECONDS = 30;
    @Parameterized.Parameter
    public NearCacheConfig.LocalUpdatePolicy localUpdatePolicy;

    @Parameterized.Parameters(name="localUpdatePolicy:{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE});
    }

    @Override
    protected Config createConfig() {
        Config config = super.createConfig();
        config.setProperty(GroupProperty.PARTITION_COUNT.getName(), "271");
        config.setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_ENABLED.getName(), "true");
        config.setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_SIZE.getName(), Integer.toString(100));
        return config;
    }

    @Override
    protected ClientConfig createClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty("hazelcast.invalidation.max.tolerated.miss.count", "0");
        clientConfig.setProperty("hazelcast.invalidation.reconciliation.interval.seconds", Integer.toString(30));
        return clientConfig;
    }

    @Test
    @Ignore(value="https://github.com/hazelcast/hazelcast/issues/12548")
    public void ensure_nearCachedClient_and_member_data_sync_eventually() throws Exception {
        final AtomicBoolean stopTest = new AtomicBoolean();
        final Config config = this.createConfig();
        this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastServerCachingProvider provider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)this.serverInstance);
        CacheManager serverCacheManager = provider.getCacheManager();
        final Cache memberCache = serverCacheManager.createCache("ClientCache", (Configuration)this.createCacheConfig(InMemoryFormat.BINARY));
        for (int i = 0; i < 1000; ++i) {
            memberCache.put((Object)i, (Object)i);
        }
        ClientConfig clientConfig = this.createClientConfig();
        clientConfig.addNearCacheConfig(this.createNearCacheConfig(InMemoryFormat.BINARY));
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastClientCachingProvider clientCachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        final Cache clientCache = clientCachingProvider.getCacheManager().createCache("ClientCache", (Configuration)this.createCacheConfig(InMemoryFormat.BINARY));
        ArrayList<Thread> threads = new ArrayList<Thread>();
        Thread shadowMember = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    HazelcastInstance member = InvalidationMemberAddRemoveTest.this.hazelcastFactory.newHazelcastInstance(config);
                    HazelcastTestSupport.sleepSeconds((int)5);
                    member.getLifecycleService().terminate();
                }
            }
        });
        threads.add(shadowMember);
        for (int i = 0; i < 5; ++i) {
            Thread populateClientNearCache = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!stopTest.get()) {
                        for (int i = 0; i < 1000; ++i) {
                            clientCache.get((Object)i);
                        }
                    }
                }
            });
            threads.add(populateClientNearCache);
        }
        Thread putFromMember = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    int key = RandomPicker.getInt((int)1000);
                    int value = RandomPicker.getInt((int)Integer.MAX_VALUE);
                    memberCache.put((Object)key, (Object)value);
                    HazelcastTestSupport.sleepAtLeastMillis((long)2L);
                }
            }
        });
        threads.add(putFromMember);
        Thread clearFromMember = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    memberCache.clear();
                    HazelcastTestSupport.sleepSeconds((int)3);
                }
            }
        });
        threads.add(clearFromMember);
        for (Thread thread : threads) {
            thread.start();
        }
        InvalidationMemberAddRemoveTest.sleepSeconds((int)30);
        stopTest.set(true);
        for (Thread thread : threads) {
            thread.join();
        }
        InvalidationMemberAddRemoveTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                for (int i = 0; i < 1000; ++i) {
                    Integer valueSeenFromMember = (Integer)memberCache.get((Object)i);
                    Integer valueSeenFromClient = (Integer)clientCache.get((Object)i);
                    if (valueSeenFromMember != null && valueSeenFromClient == null) {
                        System.err.println("found");
                        valueSeenFromClient = (Integer)clientCache.get((Object)i);
                    }
                    String msg = this.createFailureMessage(i);
                    Assert.assertEquals((String)msg, (Object)valueSeenFromMember, (Object)valueSeenFromClient);
                }
            }

            private String createFailureMessage(int i) {
                InternalPartitionService partitionService = HazelcastTestSupport.getPartitionService((HazelcastInstance)InvalidationMemberAddRemoveTest.this.serverInstance);
                Data keyData = HazelcastTestSupport.getSerializationService((HazelcastInstance)InvalidationMemberAddRemoveTest.this.serverInstance).toData((Object)i);
                int partitionId = partitionService.getPartitionId(keyData);
                NearCacheRecordStore nearCacheRecordStore = this.getNearCacheRecordStore();
                NearCacheRecord record = nearCacheRecordStore.getRecord((Object)keyData);
                long recordSequence = record == null ? -1L : record.getInvalidationSequence();
                MetaDataGenerator metaDataGenerator = this.getMetaDataGenerator();
                long memberSequence = metaDataGenerator.currentSequence("/hz/ClientCache", partitionId);
                StaleReadDetector staleReadDetector = nearCacheRecordStore.getStaleReadDetector();
                MetaDataContainer metaDataContainer = staleReadDetector.getMetaDataContainer(partitionId);
                return String.format("partition=%d, onRecordSequence=%d, latestSequence=%d, staleSequence=%d, memberSequence=%d", partitionService.getPartitionId(keyData), recordSequence, metaDataContainer.getSequence(), metaDataContainer.getStaleSequence(), memberSequence);
            }

            private MetaDataGenerator getMetaDataGenerator() {
                CacheEventHandler cacheEventHandler = ((CacheService)((CacheProxy)memberCache).getService()).getCacheEventHandler();
                return cacheEventHandler.getMetaDataGenerator();
            }

            private NearCacheRecordStore getNearCacheRecordStore() {
                NearCache nearCache = ((NearCachedClientCacheProxy)clientCache).getNearCache();
                DefaultNearCache defaultNearCache = (DefaultNearCache)nearCache.unwrap(DefaultNearCache.class);
                return defaultNearCache.getNearCacheRecordStore();
            }
        });
    }

    @Override
    protected CacheConfig createCacheConfig(InMemoryFormat inMemoryFormat) {
        CacheConfig cacheConfig = super.createCacheConfig(inMemoryFormat);
        cacheConfig.getEvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(Integer.MAX_VALUE);
        return cacheConfig;
    }

    @Override
    protected NearCacheConfig createNearCacheConfig(InMemoryFormat inMemoryFormat) {
        NearCacheConfig nearCacheConfig = super.createNearCacheConfig(inMemoryFormat);
        nearCacheConfig.setInvalidateOnChange(true).setLocalUpdatePolicy(this.localUpdatePolicy).getEvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(Integer.MAX_VALUE);
        return nearCacheConfig;
    }
}

