/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.nearcache;

import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.HazelcastServerCacheManager;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.cache.nearcache.ClientCacheInvalidationListener;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.ICacheDataStructureAdapter;
import com.hazelcast.internal.nearcache.AbstractNearCacheLeakTest;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.NearCacheTestContext;
import com.hazelcast.internal.nearcache.NearCacheTestContextBuilder;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import javax.cache.CacheManager;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheNearCacheLeakTest
extends AbstractNearCacheLeakTest<Data, String> {
    @Parameterized.Parameter
    public InMemoryFormat inMemoryFormat;
    @Parameterized.Parameter(value=1)
    public boolean serializeKeys;
    @Parameterized.Parameter(value=2)
    public NearCacheConfig.LocalUpdatePolicy localUpdatePolicy;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Parameterized.Parameters(name="format:{0} serializeKeys:{1} localUpdatePolicy:{2}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({InMemoryFormat.BINARY, true, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {InMemoryFormat.BINARY, true, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {InMemoryFormat.BINARY, false, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {InMemoryFormat.BINARY, false, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {InMemoryFormat.OBJECT, true, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {InMemoryFormat.OBJECT, true, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {InMemoryFormat.OBJECT, false, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {InMemoryFormat.OBJECT, false, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE});
    }

    @Before
    public void setUp() {
        this.nearCacheConfig = NearCacheTestUtils.createNearCacheConfig((InMemoryFormat)this.inMemoryFormat, (boolean)this.serializeKeys).setInvalidateOnChange(true).setLocalUpdatePolicy(this.localUpdatePolicy);
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createContext(int size) {
        Config config = this.createConfig();
        CacheConfig<K, V> cacheConfig = this.createCacheConfig(this.nearCacheConfig);
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastServerCachingProvider memberProvider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)member);
        HazelcastServerCacheManager memberCacheManager = (HazelcastServerCacheManager)memberProvider.getCacheManager();
        ICache memberCache = memberCacheManager.createCache("defaultNearCache", cacheConfig);
        ICacheDataStructureAdapter dataAdapter = new ICacheDataStructureAdapter(memberCache);
        ClientCacheNearCacheLeakTest.populateDataAdapter((DataStructureAdapter)dataAdapter, (int)size);
        NearCacheTestContextBuilder<K, V, Data, String> builder = this.createNearCacheContextBuilder(cacheConfig);
        return builder.setDataInstance(member).setDataAdapter((DataStructureAdapter)dataAdapter).setMemberCacheManager(memberCacheManager).build();
    }

    protected Config createConfig() {
        return this.getConfig().setProperty(GroupProperty.PARTITION_COUNT.getName(), "5");
    }

    protected ClientConfig createClientConfig() {
        return new ClientConfig().addNearCacheConfig(this.nearCacheConfig);
    }

    private <K, V> CacheConfig<K, V> createCacheConfig(NearCacheConfig nearCacheConfig) {
        CacheConfig cacheConfig = new CacheConfig().setName("defaultNearCache").setInMemoryFormat(nearCacheConfig.getInMemoryFormat());
        if (nearCacheConfig.getInMemoryFormat() == InMemoryFormat.NATIVE) {
            cacheConfig.getEvictionConfig().setEvictionPolicy(EvictionPolicy.LRU).setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.USED_NATIVE_MEMORY_PERCENTAGE).setSize(90);
        }
        return cacheConfig;
    }

    private <K, V> NearCacheTestContextBuilder<K, V, Data, String> createNearCacheContextBuilder(CacheConfig<K, V> cacheConfig) {
        ClientConfig clientConfig = this.createClientConfig();
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastClientCachingProvider provider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        HazelcastClientCacheManager cacheManager = (HazelcastClientCacheManager)provider.getCacheManager();
        ICache clientCache = cacheManager.createCache("defaultNearCache", cacheConfig);
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        String cacheNameWithPrefix = cacheManager.getCacheNameWithPrefix("defaultNearCache");
        NearCache nearCache = nearCacheManager.getNearCache(cacheNameWithPrefix);
        ClientContext clientContext = ((ClientProxy)clientCache).getContext();
        RepairingTask repairingTask = clientContext.getRepairingTask("hz:impl:cacheService");
        return new NearCacheTestContextBuilder(this.nearCacheConfig, client.getSerializationService()).setNearCacheInstance((HazelcastInstance)client).setNearCacheAdapter((DataStructureAdapter)new ICacheDataStructureAdapter(clientCache)).setNearCache(nearCache).setNearCacheManager(nearCacheManager).setCacheManager((CacheManager)cacheManager).setInvalidationListener(ClientCacheInvalidationListener.createInvalidationEventHandler(clientCache)).setRepairingTask(repairingTask);
    }
}

