/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.config.ClientIcmpPingConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.XMLConfigBuilderTest;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.xml.sax.SAXException;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class XmlClientConfigBuilderTest
extends HazelcastTestSupport {
    static final String HAZELCAST_CLIENT_START_TAG = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n";
    private static final String HAZELCAST_CLIENT_END_TAG = "</hazelcast-client>";
    private ClientConfig fullClientConfig;
    private ClientConfig defaultClientConfig;

    @Before
    public void init() throws Exception {
        URL schemaResource = XMLConfigBuilderTest.class.getClassLoader().getResource("hazelcast-client-full.xml");
        this.fullClientConfig = new XmlClientConfigBuilder(schemaResource).build();
        URL schemaResourceDefault = XMLConfigBuilderTest.class.getClassLoader().getResource("hazelcast-client-default.xml");
        this.defaultClientConfig = new XmlClientConfigBuilder(schemaResourceDefault).build();
    }

    @After
    @Before
    public void beforeAndAfter() {
        System.clearProperty("hazelcast.client.config");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testInvalidRootElement() {
        String xml = "<hazelcast><group><name>dev</name><password>clusterpass</password></group></hazelcast>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Test(expected=HazelcastException.class)
    public void loadingThroughSystemProperty_nonExistingFile() throws IOException {
        File file = File.createTempFile("foo", "bar");
        IOUtil.delete((File)file);
        System.setProperty("hazelcast.client.config", file.getAbsolutePath());
        new XmlClientConfigBuilder();
    }

    @Test
    public void loadingThroughSystemProperty_existingFile() throws IOException {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n    <group>\n        <name>foobar</name>\n        <password>dev-pass</password>\n    </group>\n</hazelcast-client>";
        File file = File.createTempFile("foo", "bar");
        file.deleteOnExit();
        PrintWriter writer = new PrintWriter(file, "UTF-8");
        writer.println(xml);
        writer.close();
        System.setProperty("hazelcast.client.config", file.getAbsolutePath());
        XmlClientConfigBuilder configBuilder = new XmlClientConfigBuilder();
        ClientConfig config = configBuilder.build();
        Assert.assertEquals((Object)"foobar", (Object)config.getGroupConfig().getName());
    }

    @Test(expected=HazelcastException.class)
    public void loadingThroughSystemProperty_nonExistingClasspathResource() throws IOException {
        System.setProperty("hazelcast.client.config", "classpath:idontexist");
        new XmlClientConfigBuilder();
    }

    @Test
    public void loadingThroughSystemProperty_existingClasspathResource() throws IOException {
        System.setProperty("hazelcast.client.config", "classpath:test-hazelcast-client.xml");
        XmlClientConfigBuilder configBuilder = new XmlClientConfigBuilder();
        ClientConfig config = configBuilder.build();
        Assert.assertEquals((Object)"foobar", (Object)config.getGroupConfig().getName());
        Assert.assertEquals((Object)"com.hazelcast.nio.ssl.BasicSSLContextFactory", (Object)config.getNetworkConfig().getSSLConfig().getFactoryClassName());
        Assert.assertEquals((long)128L, (long)config.getNetworkConfig().getSocketOptions().getBufferSize());
        Assert.assertFalse((boolean)config.getNetworkConfig().getSocketOptions().isKeepAlive());
        Assert.assertFalse((boolean)config.getNetworkConfig().getSocketOptions().isTcpNoDelay());
        Assert.assertEquals((long)3L, (long)config.getNetworkConfig().getSocketOptions().getLingerSeconds());
    }

    @Test
    public void testGroupConfig() {
        GroupConfig groupConfig = this.fullClientConfig.getGroupConfig();
        Assert.assertEquals((Object)"dev", (Object)groupConfig.getName());
        Assert.assertEquals((Object)"dev-pass", (Object)groupConfig.getPassword());
    }

    @Test
    public void testProperties() {
        Assert.assertEquals((long)6L, (long)this.fullClientConfig.getProperties().size());
        Assert.assertEquals((Object)"60000", (Object)this.fullClientConfig.getProperty("hazelcast.client.heartbeat.timeout"));
    }

    @Test
    public void testNetworkConfig() {
        ClientNetworkConfig networkConfig = this.fullClientConfig.getNetworkConfig();
        Assert.assertEquals((long)2L, (long)networkConfig.getConnectionAttemptLimit());
        Assert.assertEquals((long)2L, (long)networkConfig.getAddresses().size());
        XmlClientConfigBuilderTest.assertContains((Collection)networkConfig.getAddresses(), (Object)"127.0.0.1");
        XmlClientConfigBuilderTest.assertContains((Collection)networkConfig.getAddresses(), (Object)"127.0.0.2");
        Collection allowedPorts = networkConfig.getOutboundPortDefinitions();
        Assert.assertEquals((long)2L, (long)allowedPorts.size());
        Assert.assertTrue((boolean)allowedPorts.contains("34600"));
        Assert.assertTrue((boolean)allowedPorts.contains("34700-34710"));
        Assert.assertTrue((boolean)networkConfig.isSmartRouting());
        Assert.assertTrue((boolean)networkConfig.isRedoOperation());
        SocketInterceptorConfig socketInterceptorConfig = networkConfig.getSocketInterceptorConfig();
        Assert.assertTrue((boolean)socketInterceptorConfig.isEnabled());
        Assert.assertEquals((Object)"com.hazelcast.examples.MySocketInterceptor", (Object)socketInterceptorConfig.getClassName());
        Assert.assertEquals((Object)"bar", (Object)socketInterceptorConfig.getProperty("foo"));
        ClientAwsConfig awsConfig = networkConfig.getAwsConfig();
        Assert.assertTrue((boolean)awsConfig.isEnabled());
        Assert.assertTrue((boolean)awsConfig.isInsideAws());
        Assert.assertEquals((Object)"TEST_ACCESS_KEY", (Object)awsConfig.getAccessKey());
        Assert.assertEquals((Object)"TEST_ACCESS_KEY", (Object)awsConfig.getAccessKey());
        Assert.assertEquals((Object)"TEST_SECRET_KEY", (Object)awsConfig.getSecretKey());
        Assert.assertEquals((Object)"us-east-1", (Object)awsConfig.getRegion());
        Assert.assertEquals((Object)"ec2.amazonaws.com", (Object)awsConfig.getHostHeader());
        Assert.assertEquals((Object)"type", (Object)awsConfig.getTagKey());
        Assert.assertEquals((Object)"hz-nodes", (Object)awsConfig.getTagValue());
        Assert.assertEquals((long)11L, (long)awsConfig.getConnectionTimeoutSeconds());
    }

    @Test
    public void testSerializationConfig() {
        SerializationConfig serializationConfig = this.fullClientConfig.getSerializationConfig();
        Assert.assertEquals((long)3L, (long)serializationConfig.getPortableVersion());
        Map dsClasses = serializationConfig.getDataSerializableFactoryClasses();
        Assert.assertEquals((long)1L, (long)dsClasses.size());
        Assert.assertEquals((Object)"com.hazelcast.examples.DataSerializableFactory", dsClasses.get(1));
        Map pfClasses = serializationConfig.getPortableFactoryClasses();
        Assert.assertEquals((long)1L, (long)pfClasses.size());
        Assert.assertEquals((Object)"com.hazelcast.examples.PortableFactory", pfClasses.get(2));
        Collection serializerConfigs = serializationConfig.getSerializerConfigs();
        Assert.assertEquals((long)1L, (long)serializerConfigs.size());
        SerializerConfig serializerConfig = (SerializerConfig)serializerConfigs.iterator().next();
        Assert.assertEquals((Object)"com.hazelcast.examples.DummyType", (Object)serializerConfig.getTypeClassName());
        Assert.assertEquals((Object)"com.hazelcast.examples.SerializerFactory", (Object)serializerConfig.getClassName());
        GlobalSerializerConfig globalSerializerConfig = serializationConfig.getGlobalSerializerConfig();
        Assert.assertEquals((Object)"com.hazelcast.examples.GlobalSerializerFactory", (Object)globalSerializerConfig.getClassName());
        Assert.assertEquals((Object)ByteOrder.BIG_ENDIAN, (Object)serializationConfig.getByteOrder());
        Assert.assertTrue((boolean)serializationConfig.isCheckClassDefErrors());
        Assert.assertFalse((boolean)serializationConfig.isAllowUnsafe());
        Assert.assertFalse((boolean)serializationConfig.isEnableCompression());
        Assert.assertTrue((boolean)serializationConfig.isEnableSharedObject());
        Assert.assertTrue((boolean)serializationConfig.isUseNativeByteOrder());
    }

    @Test
    public void testProxyFactories() {
        List pfc = this.fullClientConfig.getProxyFactoryConfigs();
        Assert.assertEquals((long)3L, (long)pfc.size());
        XmlClientConfigBuilderTest.assertContains((Collection)pfc, (Object)new ProxyFactoryConfig("com.hazelcast.examples.ProxyXYZ1", "sampleService1"));
        XmlClientConfigBuilderTest.assertContains((Collection)pfc, (Object)new ProxyFactoryConfig("com.hazelcast.examples.ProxyXYZ2", "sampleService1"));
        XmlClientConfigBuilderTest.assertContains((Collection)pfc, (Object)new ProxyFactoryConfig("com.hazelcast.examples.ProxyXYZ3", "sampleService3"));
    }

    @Test
    public void testNearCacheConfigs() {
        Assert.assertEquals((long)1L, (long)this.fullClientConfig.getNearCacheConfigMap().size());
        NearCacheConfig nearCacheConfig = this.fullClientConfig.getNearCacheConfig("asd");
        Assert.assertEquals((long)2000L, (long)nearCacheConfig.getMaxSize());
        Assert.assertEquals((long)2000L, (long)nearCacheConfig.getEvictionConfig().getSize());
        Assert.assertEquals((long)90L, (long)nearCacheConfig.getTimeToLiveSeconds());
        Assert.assertEquals((long)100L, (long)nearCacheConfig.getMaxIdleSeconds());
        Assert.assertEquals((Object)"LFU", (Object)nearCacheConfig.getEvictionPolicy());
        Assert.assertEquals((Object)EvictionPolicy.LFU, (Object)nearCacheConfig.getEvictionConfig().getEvictionPolicy());
        Assert.assertTrue((boolean)nearCacheConfig.isInvalidateOnChange());
        Assert.assertTrue((boolean)nearCacheConfig.isSerializeKeys());
        Assert.assertEquals((Object)InMemoryFormat.OBJECT, (Object)nearCacheConfig.getInMemoryFormat());
    }

    @Test
    public void testSSLConfigs() {
        SSLConfig sslConfig = this.fullClientConfig.getNetworkConfig().getSSLConfig();
        Assert.assertNotNull((Object)sslConfig);
        Assert.assertFalse((boolean)sslConfig.isEnabled());
        Assert.assertEquals((Object)"com.hazelcast.examples.MySslFactory", (Object)sslConfig.getFactoryClassName());
        Assert.assertEquals((long)1L, (long)sslConfig.getProperties().size());
        Assert.assertEquals((Object)"TLS", (Object)sslConfig.getProperties().get("protocol"));
    }

    @Test
    public void testNearCacheConfig_withEvictionConfig_withPreloaderConfig() throws IOException {
        URL schemaResource = XMLConfigBuilderTest.class.getClassLoader().getResource("hazelcast-client-test.xml");
        ClientConfig clientConfig = new XmlClientConfigBuilder(schemaResource).build();
        Assert.assertEquals((Object)"MyInstanceName", (Object)clientConfig.getInstanceName());
        NearCacheConfig nearCacheConfig = clientConfig.getNearCacheConfig("nearCacheWithEvictionAndPreloader");
        Assert.assertEquals((long)10000L, (long)nearCacheConfig.getTimeToLiveSeconds());
        Assert.assertEquals((long)5000L, (long)nearCacheConfig.getMaxIdleSeconds());
        Assert.assertFalse((boolean)nearCacheConfig.isInvalidateOnChange());
        Assert.assertEquals((Object)InMemoryFormat.OBJECT, (Object)nearCacheConfig.getInMemoryFormat());
        Assert.assertTrue((boolean)nearCacheConfig.isCacheLocalEntries());
        Assert.assertNotNull((Object)nearCacheConfig.getEvictionConfig());
        Assert.assertEquals((long)100L, (long)nearCacheConfig.getEvictionConfig().getSize());
        Assert.assertEquals((Object)EvictionConfig.MaxSizePolicy.ENTRY_COUNT, (Object)nearCacheConfig.getEvictionConfig().getMaximumSizePolicy());
        Assert.assertEquals((Object)EvictionPolicy.LFU, (Object)nearCacheConfig.getEvictionConfig().getEvictionPolicy());
        Assert.assertNotNull((Object)nearCacheConfig.getPreloaderConfig());
        Assert.assertTrue((boolean)nearCacheConfig.getPreloaderConfig().isEnabled());
        Assert.assertEquals((Object)"/tmp/myNearCache", (Object)nearCacheConfig.getPreloaderConfig().getDirectory());
        Assert.assertEquals((long)2342L, (long)nearCacheConfig.getPreloaderConfig().getStoreInitialDelaySeconds());
        Assert.assertEquals((long)4223L, (long)nearCacheConfig.getPreloaderConfig().getStoreIntervalSeconds());
    }

    @Test
    public void testQueryCacheFullConfig() throws Exception {
        QueryCacheConfig queryCacheConfig = (QueryCacheConfig)((Map)this.fullClientConfig.getQueryCacheConfigs().get("map-name")).get("query-cache-name");
        EntryListenerConfig entryListenerConfig = (EntryListenerConfig)queryCacheConfig.getEntryListenerConfigs().get(0);
        Assert.assertEquals((Object)"query-cache-name", (Object)queryCacheConfig.getName());
        Assert.assertTrue((boolean)entryListenerConfig.isIncludeValue());
        Assert.assertFalse((boolean)entryListenerConfig.isLocal());
        Assert.assertEquals((Object)"com.hazelcast.examples.EntryListener", (Object)entryListenerConfig.getClassName());
        Assert.assertTrue((boolean)queryCacheConfig.isIncludeValue());
        Assert.assertEquals((long)1L, (long)queryCacheConfig.getBatchSize());
        Assert.assertEquals((long)16L, (long)queryCacheConfig.getBufferSize());
        Assert.assertEquals((long)0L, (long)queryCacheConfig.getDelaySeconds());
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)queryCacheConfig.getEvictionConfig().getEvictionPolicy());
        Assert.assertEquals((Object)EvictionConfig.MaxSizePolicy.ENTRY_COUNT, (Object)queryCacheConfig.getEvictionConfig().getMaximumSizePolicy());
        Assert.assertEquals((long)10000L, (long)queryCacheConfig.getEvictionConfig().getSize());
        Assert.assertEquals((Object)InMemoryFormat.BINARY, (Object)queryCacheConfig.getInMemoryFormat());
        Assert.assertFalse((boolean)queryCacheConfig.isCoalesce());
        Assert.assertTrue((boolean)queryCacheConfig.isPopulate());
        for (MapIndexConfig mapIndexConfig : queryCacheConfig.getIndexConfigs()) {
            Assert.assertEquals((Object)"name", (Object)mapIndexConfig.getAttribute());
            Assert.assertFalse((boolean)mapIndexConfig.isOrdered());
        }
        Assert.assertEquals((Object)"com.hazelcast.examples.ExamplePredicate", (Object)queryCacheConfig.getPredicateConfig().getClassName());
    }

    @Test
    public void testFlakeIdGeneratorConfig() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n<flake-id-generator name='gen'>  <prefetch-count>3</prefetch-count>  <prefetch-validity-millis>10</prefetch-validity-millis></flake-id-generator></hazelcast-client>";
        ClientConfig config = XmlClientConfigBuilderTest.buildConfig(xml);
        ClientFlakeIdGeneratorConfig fConfig = config.findFlakeIdGeneratorConfig("gen");
        Assert.assertEquals((Object)"gen", (Object)fConfig.getName());
        Assert.assertEquals((long)3L, (long)fConfig.getPrefetchCount());
        Assert.assertEquals((long)10L, (long)fConfig.getPrefetchValidityMillis());
    }

    @Test
    public void testConnectionStrategyConfig() {
        ClientConnectionStrategyConfig connectionStrategyConfig = this.fullClientConfig.getConnectionStrategyConfig();
        Assert.assertTrue((boolean)connectionStrategyConfig.isAsyncStart());
        Assert.assertEquals((Object)ClientConnectionStrategyConfig.ReconnectMode.ASYNC, (Object)connectionStrategyConfig.getReconnectMode());
    }

    @Test
    public void testLeftovers() {
        Assert.assertEquals((long)40L, (long)this.fullClientConfig.getExecutorPoolSize());
        Assert.assertEquals((Object)"com.hazelcast.security.UsernamePasswordCredentials", (Object)this.fullClientConfig.getSecurityConfig().getCredentialsClassname());
        Assert.assertEquals((long)40L, (long)this.fullClientConfig.getExecutorPoolSize());
        Assert.assertEquals((Object)"com.hazelcast.client.util.RandomLB", (Object)this.fullClientConfig.getLoadBalancer().getClass().getName());
        List listenerConfigs = this.fullClientConfig.getListenerConfigs();
        Assert.assertEquals((long)3L, (long)listenerConfigs.size());
        XmlClientConfigBuilderTest.assertContains((Collection)listenerConfigs, (Object)new ListenerConfig("com.hazelcast.examples.MembershipListener"));
        XmlClientConfigBuilderTest.assertContains((Collection)listenerConfigs, (Object)new ListenerConfig("com.hazelcast.examples.InstanceListener"));
        XmlClientConfigBuilderTest.assertContains((Collection)listenerConfigs, (Object)new ListenerConfig("com.hazelcast.examples.MigrationListener"));
    }

    @Test
    public void testXSDDefaultXML() throws SAXException, IOException {
        this.testXSDConfigXML("hazelcast-client-default.xml");
    }

    @Test
    public void testFullConfigXML() throws SAXException, IOException {
        this.testXSDConfigXML("hazelcast-client-full.xml");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testMissingNamespace() {
        String xml = "<hazelcast-client/>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testInvalidNamespace() {
        String xml = "<hazelcast-client xmlns=\"http://foo.bar\"/>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Test
    public void testValidNamespace() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n</hazelcast-client>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testHazelcastClientTagAppearsTwice() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n<hazelcast-client/><hazelcast-client/>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Test
    public void testNearCacheInMemoryFormatNative_withKeysByReference() {
        String mapName = "testMapNearCacheInMemoryFormatNative";
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n  <near-cache name=\"" + mapName + "\">\n" + "    <in-memory-format>NATIVE</in-memory-format>\n" + "    <serialize-keys>false</serialize-keys>\n" + "  </near-cache>\n" + HAZELCAST_CLIENT_END_TAG;
        ClientConfig clientConfig = XmlClientConfigBuilderTest.buildConfig(xml);
        NearCacheConfig ncConfig = clientConfig.getNearCacheConfig(mapName);
        Assert.assertEquals((Object)InMemoryFormat.NATIVE, (Object)ncConfig.getInMemoryFormat());
        Assert.assertTrue((boolean)ncConfig.isSerializeKeys());
    }

    @Test
    public void testNearCacheEvictionPolicy() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n<near-cache name=\"lfu\">  <eviction eviction-policy=\"LFU\"/></near-cache><near-cache name=\"lru\">  <eviction eviction-policy=\"LRU\"/></near-cache><near-cache name=\"none\">  <eviction eviction-policy=\"NONE\"/></near-cache><near-cache name=\"random\">  <eviction eviction-policy=\"RANDOM\"/></near-cache></hazelcast-client>";
        ClientConfig clientConfig = XmlClientConfigBuilderTest.buildConfig(xml);
        Assert.assertEquals((Object)EvictionPolicy.LFU, (Object)this.getNearCacheEvictionPolicy("lfu", clientConfig));
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)this.getNearCacheEvictionPolicy("lru", clientConfig));
        Assert.assertEquals((Object)EvictionPolicy.NONE, (Object)this.getNearCacheEvictionPolicy("none", clientConfig));
        Assert.assertEquals((Object)EvictionPolicy.RANDOM, (Object)this.getNearCacheEvictionPolicy("random", clientConfig));
    }

    @Test
    public void testClientUserCodeDeploymentConfig() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n<user-code-deployment enabled=\"true\">\n        <jarPaths>\n            <jarPath>/User/test/test.jar</jarPath>\n        </jarPaths>\n        <classNames>\n            <className>test.testClassName</className>\n            <className>test.testClassName2</className>\n        </classNames>\n    </user-code-deployment></hazelcast-client>";
        ClientConfig clientConfig = XmlClientConfigBuilderTest.buildConfig(xml);
        ClientUserCodeDeploymentConfig userCodeDeploymentConfig = clientConfig.getUserCodeDeploymentConfig();
        Assert.assertEquals((Object)true, (Object)userCodeDeploymentConfig.isEnabled());
        List classNames = userCodeDeploymentConfig.getClassNames();
        Assert.assertEquals((long)2L, (long)classNames.size());
        Assert.assertEquals((Object)true, (Object)classNames.contains("test.testClassName"));
        Assert.assertEquals((Object)true, (Object)classNames.contains("test.testClassName2"));
        List jarPaths = userCodeDeploymentConfig.getJarPaths();
        Assert.assertEquals((long)1L, (long)jarPaths.size());
        Assert.assertEquals((Object)true, (Object)jarPaths.contains("/User/test/test.jar"));
    }

    @Test
    public void testClientIcmpPingConfig() {
        ClientIcmpPingConfig icmpPingConfig = this.fullClientConfig.getNetworkConfig().getClientIcmpPingConfig();
        Assert.assertEquals((Object)false, (Object)icmpPingConfig.isEnabled());
        Assert.assertEquals((long)2000L, (long)icmpPingConfig.getTimeoutMilliseconds());
        Assert.assertEquals((long)3000L, (long)icmpPingConfig.getIntervalMilliseconds());
        Assert.assertEquals((long)100L, (long)icmpPingConfig.getTtl());
        Assert.assertEquals((long)5L, (long)icmpPingConfig.getMaxAttempts());
        Assert.assertEquals((Object)false, (Object)icmpPingConfig.isEchoFailFastOnStartup());
    }

    @Test
    public void testClientIcmpPingConfig_defaults() {
        ClientIcmpPingConfig icmpPingConfig = this.defaultClientConfig.getNetworkConfig().getClientIcmpPingConfig();
        Assert.assertEquals((Object)false, (Object)icmpPingConfig.isEnabled());
        Assert.assertEquals((long)1000L, (long)icmpPingConfig.getTimeoutMilliseconds());
        Assert.assertEquals((long)1000L, (long)icmpPingConfig.getIntervalMilliseconds());
        Assert.assertEquals((long)255L, (long)icmpPingConfig.getTtl());
        Assert.assertEquals((long)2L, (long)icmpPingConfig.getMaxAttempts());
        Assert.assertEquals((Object)true, (Object)icmpPingConfig.isEchoFailFastOnStartup());
    }

    private EvictionPolicy getNearCacheEvictionPolicy(String mapName, ClientConfig clientConfig) {
        return clientConfig.getNearCacheConfig(mapName).getEvictionConfig().getEvictionPolicy();
    }

    static ClientConfig buildConfig(String xml, Properties properties) {
        ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes());
        XmlClientConfigBuilder configBuilder = new XmlClientConfigBuilder((InputStream)bis);
        configBuilder.setProperties(properties);
        return configBuilder.build();
    }

    static ClientConfig buildConfig(String xml, String key, String value) {
        Properties properties = new Properties();
        properties.setProperty(key, value);
        return XmlClientConfigBuilderTest.buildConfig(xml, properties);
    }

    public static ClientConfig buildConfig(String xml) {
        return XmlClientConfigBuilderTest.buildConfig(xml, null);
    }

    private void testXSDConfigXML(String xmlFileName) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaResource = XMLConfigBuilderTest.class.getClassLoader().getResource("hazelcast-client-config-3.10.xsd");
        InputStream xmlResource = XMLConfigBuilderTest.class.getClassLoader().getResourceAsStream(xmlFileName);
        Schema schema = factory.newSchema(schemaResource);
        StreamSource source = new StreamSource(xmlResource);
        Validator validator = schema.newValidator();
        try {
            validator.validate(source);
        }
        catch (SAXException ex) {
            Assert.fail((String)(xmlFileName + " is not valid because: " + ex.toString()));
        }
    }
}

