/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.nio.Address;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ConnectMemberListOrderTest
extends ClientTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();
    @Parameterized.Parameter
    public String shuffleMemberList;

    @Parameterized.Parameters(name="shuffleMemberList == {0}")
    public static Collection<Object[]> params() {
        return Arrays.asList({"false"}, {"true"});
    }

    @After
    public void cleanup() {
        this.factory.shutdownAll();
    }

    @Test
    public void testPossibleMemberAddressesAfterDisconnection() throws Exception {
        HazelcastInstance instance = this.factory.newHazelcastInstance();
        ClientConfig config = new ClientConfig();
        config.setProperty(ClientProperty.SHUFFLE_MEMBER_LIST.getName(), this.shuffleMemberList);
        HazelcastInstance client = this.factory.newHazelcastClient(config);
        final CountDownLatch connectedBack = new CountDownLatch(1);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (LifecycleEvent.LifecycleState.CLIENT_CONNECTED.equals((Object)event.getState())) {
                    connectedBack.countDown();
                }
            }
        });
        this.factory.newHazelcastInstance();
        this.factory.newHazelcastInstance();
        this.makeSureConnectedToServers(client, 3);
        Address lastConnectedMemberAddress = new Address((InetSocketAddress)instance.getLocalEndpoint().getSocketAddress());
        instance.shutdown();
        ConnectMemberListOrderTest.assertOpenEventually((CountDownLatch)connectedBack);
        Collection<Address> possibleMemberAddresses = this.getPossibleMemberAddresses(client);
        Assert.assertEquals((long)3L, (long)possibleMemberAddresses.size());
        Assert.assertNotEquals((Object)lastConnectedMemberAddress, (Object)possibleMemberAddresses.iterator().next());
    }

    private Collection<Address> getPossibleMemberAddresses(HazelcastInstance client) {
        HazelcastClientInstanceImpl instanceImpl = this.getHazelcastClientInstanceImpl(client);
        ClientConnectionManagerImpl connectionManager = (ClientConnectionManagerImpl)instanceImpl.getConnectionManager();
        return connectionManager.getPossibleMemberAddresses();
    }
}

