/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.executor.durable;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.durableexecutor.DurableExecutorServiceFuture;
import com.hazelcast.durableexecutor.StaleTaskIdException;
import com.hazelcast.executor.ExecutorServiceTestSupport;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientDurableRetrieveResultTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;
    private HazelcastInstance instance1;
    private HazelcastInstance instance2;

    @Before
    public void setup() {
        this.instance1 = this.hazelcastFactory.newHazelcastInstance();
        this.instance2 = this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testDisposeResult() throws Exception {
        String name = HazelcastTestSupport.randomString();
        String key = HazelcastTestSupport.generateKeyOwnedBy((HazelcastInstance)this.instance1);
        DurableExecutorService executorService = this.client.getDurableExecutorService(name);
        ExecutorServiceTestSupport.BasicTestCallable task = new ExecutorServiceTestSupport.BasicTestCallable();
        DurableExecutorServiceFuture future = executorService.submitToKeyOwner((Callable)task, (Object)key);
        future.get();
        executorService.disposeResult(future.getTaskId());
        Future resultFuture = executorService.retrieveResult(future.getTaskId());
        Assert.assertNull(resultFuture.get());
    }

    @Test
    public void testRetrieveAndDispose_WhenClientDown() throws Exception {
        String name = HazelcastTestSupport.randomString();
        DurableExecutorService executorService = this.client.getDurableExecutorService(name);
        ExecutorServiceTestSupport.SleepingTask task = new ExecutorServiceTestSupport.SleepingTask(4L);
        long taskId = executorService.submit((Callable)task).getTaskId();
        this.client.shutdown();
        this.client = this.hazelcastFactory.newHazelcastClient();
        executorService = this.client.getDurableExecutorService(name);
        Future future = executorService.retrieveAndDisposeResult(taskId);
        Assert.assertTrue((boolean)((Boolean)future.get()));
        Future resultFuture = executorService.retrieveResult(taskId);
        Assert.assertNull(resultFuture.get());
    }

    @Test
    public void testRetrieveAndDispose_WhenOwnerMemberDown() throws Exception {
        String name = HazelcastTestSupport.randomString();
        String key = HazelcastTestSupport.generateKeyOwnedBy((HazelcastInstance)this.instance2);
        DurableExecutorService executorService = this.client.getDurableExecutorService(name);
        ExecutorServiceTestSupport.SleepingTask task = new ExecutorServiceTestSupport.SleepingTask(4L);
        long taskId = executorService.submitToKeyOwner((Callable)task, (Object)key).getTaskId();
        this.instance2.shutdown();
        Future future = executorService.retrieveAndDisposeResult(taskId);
        Assert.assertTrue((boolean)((Boolean)future.get()));
        Future resultFuture = executorService.retrieveResult(taskId);
        Assert.assertNull(resultFuture.get());
    }

    @Test
    public void testRetrieve_WhenSubmitterMemberDown() throws Exception {
        String name = HazelcastTestSupport.randomString();
        DurableExecutorService executorService = this.client.getDurableExecutorService(name);
        ExecutorServiceTestSupport.SleepingTask task = new ExecutorServiceTestSupport.SleepingTask(4L);
        long taskId = executorService.submit((Callable)task).getTaskId();
        this.client.shutdown();
        this.client = this.hazelcastFactory.newHazelcastClient();
        executorService = this.client.getDurableExecutorService(name);
        Future future = executorService.retrieveResult(taskId);
        Assert.assertTrue((boolean)((Boolean)future.get()));
    }

    @Test
    public void testRetrieve_WhenOwnerMemberDown() throws Exception {
        String name = HazelcastTestSupport.randomString();
        String key = HazelcastTestSupport.generateKeyOwnedBy((HazelcastInstance)this.instance2);
        DurableExecutorService executorService = this.client.getDurableExecutorService(name);
        ExecutorServiceTestSupport.SleepingTask task = new ExecutorServiceTestSupport.SleepingTask(4L);
        long taskId = executorService.submitToKeyOwner((Callable)task, (Object)key).getTaskId();
        this.instance2.shutdown();
        Future future = executorService.retrieveResult(taskId);
        Assert.assertTrue((boolean)((Boolean)future.get()));
    }

    @Test
    public void testRetrieve_WhenResultOverwritten() throws Exception {
        String name = HazelcastTestSupport.randomString();
        DurableExecutorService executorService = this.client.getDurableExecutorService(name);
        DurableExecutorServiceFuture future = executorService.submitToKeyOwner((Callable)new ExecutorServiceTestSupport.BasicTestCallable(), (Object)name);
        long taskId = future.getTaskId();
        future.get();
        for (int i = 0; i < 100; ++i) {
            executorService.submitToKeyOwner((Callable)new ExecutorServiceTestSupport.BasicTestCallable(), (Object)name);
        }
        Future resultFuture = executorService.retrieveResult(taskId);
        try {
            resultFuture.get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof StaleTaskIdException));
        }
    }
}

