/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.flakeidgen.impl;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.flakeidgen.impl.FlakeIdConcurrencyTestUtil;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.function.Supplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class FlakeIdGenerator_ClientIntegrationTest {
    private TestHazelcastFactory factory;
    private HazelcastInstance instance;

    public void before(ClientConfig config) {
        this.factory = new TestHazelcastFactory(2);
        HazelcastInstance[] instances = this.factory.newInstances();
        this.instance = this.factory.newHazelcastClient(config);
    }

    @After
    public void after() {
        this.factory.shutdownAll();
    }

    @Test
    public void smokeTest() throws Exception {
        this.before(null);
        final FlakeIdGenerator generator = this.instance.getFlakeIdGenerator("gen");
        FlakeIdConcurrencyTestUtil.concurrentlyGenerateIds((Supplier)new Supplier<Long>(){

            public Long get() {
                return generator.newId();
            }
        });
    }

    @Test
    public void configTest() throws Exception {
        int myBatchSize = 3;
        this.before(new ClientConfig().addFlakeIdGeneratorConfig(new ClientFlakeIdGeneratorConfig("gen").setPrefetchCount(myBatchSize).setPrefetchValidityMillis(3000L)));
        FlakeIdGenerator generator = this.instance.getFlakeIdGenerator("gen");
        Assert.assertTrue((String)"This test assumes default validity be larger than 3000 by a good margin", (boolean)true);
        long id1 = generator.newId();
        long id2 = generator.newId();
        Assert.assertEquals((long)(id1 + 65536L), (long)id2);
        Thread.sleep(3000L);
        long id3 = generator.newId();
        Assert.assertTrue((id1 + 65536L * (long)myBatchSize < id3 ? 1 : 0) != 0);
    }

    @Test
    public void test_init() {
        this.before(null);
        FlakeIdGenerator gen = this.instance.getFlakeIdGenerator("gen");
        long currentId = gen.newId();
        Assert.assertTrue((boolean)gen.init(currentId / 2L));
        Assert.assertFalse((boolean)gen.init(currentId * 2L));
    }
}

