/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.internal.diagnostics.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientConfigValidatorTest
extends HazelcastTestSupport {
    private static final String MAP_NAME = "default";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private TestHazelcastFactory factory = new TestHazelcastFactory();

    @Test
    public void getMap_throws_illegalArgumentException_whenLocalUpdatePolicy_is_cacheOnUpdate() {
        NearCacheConfig nearCacheConfig = new NearCacheConfig();
        nearCacheConfig.setLocalUpdatePolicy(NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addNearCacheConfig(nearCacheConfig);
        this.factory.newHazelcastInstance();
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(CoreMatchers.containsString((String)"Wrong `local-update-policy`"));
        client.getMap(MAP_NAME);
    }

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }
}

