/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.listeners;

import com.hazelcast.client.listeners.AbstractListenersOnReconnectTest;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.eventservice.impl.EventServiceImpl;
import com.hazelcast.spi.impl.eventservice.impl.EventServiceSegment;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ReplicatedMapEntryListenerOnReconnectTest
extends AbstractListenersOnReconnectTest {
    private ReplicatedMap<String, String> replicatedMap;

    @Override
    String getServiceName() {
        return "hz:impl:replicatedMapService";
    }

    @Override
    protected String addListener() {
        this.replicatedMap = this.client.getReplicatedMap(ReplicatedMapEntryListenerOnReconnectTest.randomString());
        EntryAdapter<String, String> listener = new EntryAdapter<String, String>(){

            public void onEntryEvent(EntryEvent<String, String> event) {
                ReplicatedMapEntryListenerOnReconnectTest.this.onEvent((String)event.getKey());
            }
        };
        return this.replicatedMap.addEntryListener((EntryListener)listener);
    }

    @Override
    public void produceEvent(String event) {
        this.replicatedMap.put((Object)event, (Object)ReplicatedMapEntryListenerOnReconnectTest.randomString());
    }

    @Override
    public boolean removeListener(String registrationId) {
        return this.replicatedMap.removeEntryListener(registrationId);
    }

    @Override
    protected void validateRegistrationsOnMembers(final TestHazelcastFactory factory) {
        ReplicatedMapEntryListenerOnReconnectTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                boolean found = false;
                for (HazelcastInstance instance : factory.getAllHazelcastInstances()) {
                    NodeEngineImpl nodeEngineImpl = HazelcastTestSupport.getNodeEngineImpl((HazelcastInstance)instance);
                    EventServiceImpl eventService = (EventServiceImpl)nodeEngineImpl.getEventService();
                    EventServiceSegment serviceSegment = eventService.getSegment(ReplicatedMapEntryListenerOnReconnectTest.this.getServiceName(), false);
                    if (serviceSegment == null || serviceSegment.getRegistrationIdMap().size() != 1) continue;
                    found = true;
                }
                Assert.assertTrue((boolean)found);
            }
        });
    }
}

