/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.projection.Projection;
import com.hazelcast.projection.Projections;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.test.HazelcastTestSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractMapQueryPartitionIteratorTest
extends HazelcastTestSupport {
    protected TestHazelcastFactory factory;
    protected HazelcastInstance server;
    protected HazelcastInstance client;

    @After
    public void teardown() {
        this.factory.terminateAll();
    }

    @Test(expected=NoSuchElementException.class)
    public void test_next_Throws_Exception_On_EmptyPartition() throws Exception {
        ClientMapProxy proxy = this.getMapProxy();
        proxy.iterator(10, 1, (Projection)new TestProjection(), (Predicate)TruePredicate.truePredicate()).next();
    }

    @Test(expected=NullPointerException.class)
    public void test_null_projection_throws_exception() throws Exception {
        ClientMapProxy proxy = this.getMapProxy();
        proxy.iterator(10, 1, null, (Predicate)TruePredicate.truePredicate());
    }

    @Test(expected=NullPointerException.class)
    public void test_null_predicate_throws_exception() throws Exception {
        ClientMapProxy proxy = this.getMapProxy();
        proxy.iterator(10, 1, (Projection)new TestProjection(), null);
    }

    @Test
    public void test_HasNext_Returns_False_On_EmptyPartition() throws Exception {
        ClientMapProxy proxy = this.getMapProxy();
        Iterator iterator = proxy.iterator(10, 1, (Projection)new TestProjection(), (Predicate)TruePredicate.truePredicate());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void test_Next_Returns_Value_On_NonEmptyPartition() throws Exception {
        ClientMapProxy proxy = this.getMapProxy();
        String key = AbstractMapQueryPartitionIteratorTest.generateKeyForPartition((HazelcastInstance)this.server, (int)1);
        String value = AbstractMapQueryPartitionIteratorTest.randomString();
        proxy.put((Object)key, (Object)value);
        Iterator iterator = proxy.iterator(10, 1, new GetValueProjection(), (Predicate)TruePredicate.truePredicate());
        String next = (String)iterator.next();
        Assert.assertEquals((Object)value, (Object)next);
    }

    @Test
    public void test_Next_Returns_Value_On_NonEmptyPartition_and_HasNext_Returns_False_when_Item_Consumed() throws Exception {
        ClientMapProxy proxy = this.getMapProxy();
        String key = AbstractMapQueryPartitionIteratorTest.generateKeyForPartition((HazelcastInstance)this.server, (int)1);
        String value = AbstractMapQueryPartitionIteratorTest.randomString();
        proxy.put((Object)key, (Object)value);
        Iterator iterator = proxy.iterator(10, 1, new GetValueProjection(), (Predicate)TruePredicate.truePredicate());
        String next = (String)iterator.next();
        Assert.assertEquals((Object)value, (Object)next);
        boolean hasNext = iterator.hasNext();
        Assert.assertFalse((boolean)hasNext);
    }

    @Test
    public void test_HasNext_Returns_True_On_NonEmptyPartition() throws Exception {
        ClientMapProxy proxy = this.getMapProxy();
        String key = AbstractMapQueryPartitionIteratorTest.generateKeyForPartition((HazelcastInstance)this.server, (int)1);
        String value = AbstractMapQueryPartitionIteratorTest.randomString();
        proxy.put((Object)key, (Object)value);
        Iterator iterator = proxy.iterator(10, 1, (Projection)new TestProjection(), (Predicate)TruePredicate.truePredicate());
        Assert.assertTrue((boolean)iterator.hasNext());
    }

    @Test
    public void test_with_projection_and_true_predicate() throws Exception {
        ClientMapProxy proxy = this.getMapProxy();
        for (int i = 0; i < 100; ++i) {
            String key = AbstractMapQueryPartitionIteratorTest.generateKeyForPartition((HazelcastInstance)this.server, (int)1);
            proxy.put((Object)key, (Object)AbstractMapQueryPartitionIteratorTest.randomString());
        }
        Iterator iterator = proxy.iterator(10, 1, (Projection)new TestProjection(), (Predicate)TruePredicate.truePredicate());
        ArrayList projected = this.collectAll(iterator);
        Collection actualValues = proxy.values();
        Assert.assertEquals((long)actualValues.size(), (long)projected.size());
        for (String value : actualValues) {
            Assert.assertTrue((boolean)projected.contains("dummy" + value));
        }
    }

    @Test
    public void test_with_projection_and_predicate() throws Exception {
        ClientMapProxy intMap = this.getMapProxy();
        for (int i = 0; i < 100; ++i) {
            String key = AbstractMapQueryPartitionIteratorTest.generateKeyForPartition((HazelcastInstance)this.server, (int)1);
            intMap.put((Object)key, (Object)i);
        }
        Iterator iterator = intMap.iterator(10, 1, Projections.identity(), (Predicate)new EvenPredicate());
        ArrayList projected = this.collectAll(iterator);
        for (Map.Entry i : projected) {
            Assert.assertTrue(((Integer)i.getValue() % 2 == 0 ? 1 : 0) != 0);
        }
        Collection actualValues = intMap.values();
        Assert.assertEquals((long)(actualValues.size() / 2), (long)projected.size());
        for (Map.Entry e : intMap.entrySet()) {
            if ((Integer)e.getValue() % 2 != 0) continue;
            Assert.assertTrue((boolean)projected.contains(e));
        }
    }

    private <T> ArrayList<T> collectAll(Iterator<T> iterator) {
        ArrayList<T> projected = new ArrayList<T>();
        while (iterator.hasNext()) {
            projected.add(iterator.next());
        }
        return projected;
    }

    @Test(expected=UnsupportedOperationException.class)
    public void test_remove_Throws_Exception() throws Exception {
        ClientMapProxy proxy = this.getMapProxy();
        Iterator iterator = proxy.iterator(10, 1, (Projection)new TestProjection(), (Predicate)TruePredicate.truePredicate());
        iterator.remove();
    }

    @Test
    public void test_Next_Returns_Values_When_FetchSizeExceeds_On_NonEmptyPartition() throws Exception {
        ClientMapProxy proxy = this.getMapProxy();
        String value = AbstractMapQueryPartitionIteratorTest.randomString();
        for (int i = 0; i < 100; ++i) {
            String key = AbstractMapQueryPartitionIteratorTest.generateKeyForPartition((HazelcastInstance)this.server, (int)1);
            proxy.put((Object)key, (Object)value);
        }
        Iterator iterator = proxy.iterator(10, 1, new GetValueProjection(), (Predicate)TruePredicate.truePredicate());
        for (int i = 0; i < 100; ++i) {
            String val = (String)iterator.next();
            Assert.assertEquals((Object)value, (Object)val);
        }
    }

    protected ClientConfig getClientConfig() {
        return new ClientConfig();
    }

    private <K, V> ClientMapProxy<K, V> getMapProxy() {
        String mapName = AbstractMapQueryPartitionIteratorTest.randomString();
        return (ClientMapProxy)this.client.getMap(mapName);
    }

    private static class GetValueProjection<T>
    extends Projection<Map.Entry<String, T>, T> {
        private GetValueProjection() {
        }

        public T transform(Map.Entry<String, T> input) {
            return input.getValue();
        }
    }

    private static class TestProjection
    extends Projection<Map.Entry<String, String>, String> {
        private TestProjection() {
        }

        public String transform(Map.Entry<String, String> input) {
            return "dummy" + input.getValue();
        }
    }

    private static class EvenPredicate
    implements Predicate<String, Integer> {
        private EvenPredicate() {
        }

        public boolean apply(Map.Entry<String, Integer> mapEntry) {
            return mapEntry.getValue() % 2 == 0;
        }
    }
}

